/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.tool;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLTableInit {
    private static final Logger LOG = LoggerFactory.getLogger(MySQLTableInit.class);
    private static final String CREATE_SQL_FORMAT = "CREATE TABLE `%s` (  `code` int(11) NOT NULL,  `parent_code` int(11) NOT NULL,  `name` varchar(100) NOT NULL,  `level` tinyint(4) NOT NULL,  `center` varchar(30) DEFAULT NULL,  `polyline` mediumtext NOT NULL)";

    public static void init(DataSource ds, String tableName) throws SQLException {
        String createSql = null;
        createSql = tableName == null ? String.format(CREATE_SQL_FORMAT, "region_data") : String.format(CREATE_SQL_FORMAT, tableName);
        LOG.info("Initialize mysql table, DDL: {}", (Object)createSql);
        try (Connection conn = ds.getConnection();
             Statement stmt = conn.createStatement();){
            stmt.execute(createSql);
        }
        LOG.info("Initialize mysql table successfully.");
    }
}

