/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.tool;

import java.awt.Polygon;
import java.awt.geom.Line2D;
import tech.spiro.addrparser.common.Point;

public class MapTools {
    private static double EARTH_RADIUS = 6378137.0;

    private static double rad(double d) {
        return d * Math.PI / 180.0;
    }

    public static double getPoint2PointDistance(Point p1, Point p2) {
        double radLat1 = MapTools.rad(p1.getLat());
        double radLat2 = MapTools.rad(p2.getLat());
        double a = radLat1 - radLat2;
        double b = MapTools.rad(p1.getLon()) - MapTools.rad(p2.getLon());
        double s = 2.0 * Math.asin(Math.sqrt(Math.pow(Math.sin(a / 2.0), 2.0) + Math.cos(radLat1) * Math.cos(radLat2) * Math.pow(Math.sin(b / 2.0), 2.0)));
        s *= EARTH_RADIUS;
        s = (double)Math.round(s * 10000.0) / 10000.0;
        return s;
    }

    public static double getPoint2LineDistance(Point p, Point lineStartPoint, Point lineEndPoint) {
        double du = Line2D.ptSegDist(lineStartPoint.getLon(), lineStartPoint.getLat(), lineEndPoint.getLon(), lineEndPoint.getLat(), p.getLon(), p.getLat());
        Point p2 = new Point(p.getLon(), p.getLat() + du);
        return MapTools.getPoint2PointDistance(p, p2);
    }

    public static boolean inCircleArea(Point p, Point centerPoint, double radius) {
        double dis = MapTools.getPoint2PointDistance(p, centerPoint);
        return dis < radius;
    }

    public static boolean inRectangleArea(Point p, Point upLeftPoint, Point downRightPoint) {
        return p.getLon() > upLeftPoint.getLon() && p.getLon() < downRightPoint.getLon() && p.getLat() < upLeftPoint.getLat() && p.getLat() > downRightPoint.getLat();
    }

    public static boolean inPolygonArea(Point p, Point[] area) {
        Polygon pol = new Polygon();
        for (int i = 0; i < area.length; ++i) {
            pol.addPoint((int)(area[i].getLon() * 100000.0), (int)(area[i].getLat() * 100000.0));
        }
        return pol.contains((int)(p.getLon() * 100000.0), (int)(p.getLat() * 100000.0));
    }

    public static boolean yawing(Point p, Point[] line, double distance) {
        for (int i = 0; i < line.length - 1; ++i) {
            if (!(MapTools.getPoint2LineDistance(p, line[i], line[i + 1]) < distance)) continue;
            return false;
        }
        return true;
    }
}

