/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.tool;

import com.mysql.jdbc.jdbc2.optional.MysqlDataSource;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import tech.spiro.addrparser.crawler.GetRegionException;
import tech.spiro.addrparser.io.IOPipeline;
import tech.spiro.addrparser.io.file.JSONFileRegionDataInput;
import tech.spiro.addrparser.io.rdbms.RdbmsRegionDataOutput;
import tech.spiro.addrparser.tool.MySQLTableInit;

public class JSONFile2MySQL {
    private static Options options = new Options();

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("JSONFile2MySQL", options);
    }

    public static void main(String[] args) throws IOException, GetRegionException {
        DefaultParser parser = new DefaultParser();
        try {
            String file;
            CommandLine cmd = parser.parse(options, args);
            DataSource dataSource = JSONFile2MySQL.buildDataSource(cmd);
            String tableName = cmd.getOptionValue('t');
            if (cmd.hasOption('i')) {
                try {
                    MySQLTableInit.init(dataSource, tableName);
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    System.exit(-1);
                }
            }
            if ((file = cmd.getOptionValue('f')) != null) {
                JSONFileRegionDataInput dataInput = new JSONFileRegionDataInput(file);
                RdbmsRegionDataOutput dataOutput = null;
                dataOutput = tableName == null ? new RdbmsRegionDataOutput(dataSource) : new RdbmsRegionDataOutput(dataSource, tableName);
                IOPipeline pipeline = new IOPipeline(dataInput, dataOutput);
                pipeline.start();
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            JSONFile2MySQL.printHelp();
            System.exit(-1);
        }
    }

    public static DataSource buildDataSource(CommandLine cmd) throws ParseException {
        String mysqlHost = cmd.getOptionValue('h');
        int mysqlPort = 3306;
        if (cmd.hasOption('p')) {
            try {
                mysqlPort = Integer.valueOf(cmd.getOptionValue('p'));
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage());
            }
        }
        String mysqlDB = cmd.getOptionValue('d');
        String mysqlUser = cmd.getOptionValue('u');
        String mysqlPassword = cmd.getOptionValue('a');
        MysqlDataSource dataSource = new MysqlDataSource();
        dataSource.setServerName(mysqlHost);
        dataSource.setPort(mysqlPort);
        dataSource.setDatabaseName(mysqlDB);
        dataSource.setUser(mysqlUser);
        dataSource.setPassword(mysqlPassword);
        try {
            Connection connection = dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new ParseException("DataSource get connection failed:" + e.getMessage());
        }
        return dataSource;
    }

    static {
        options.addOption("f", "file", true, "Json region data file path");
        options.addRequiredOption("h", "host", true, "MySQL host");
        options.addOption("p", "port", true, "MySQL port, default 3306");
        options.addRequiredOption("d", "db", true, "MySQL database");
        options.addRequiredOption("u", "user", true, "MySQL user");
        options.addRequiredOption("a", "password", true, "MySQL password");
        options.addOption("t", "table-name", true, "Default: 'region_data', Region data table name");
        options.addOption("i", "init", false, "Init table schema");
    }
}

