/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.tool;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import tech.spiro.addrparser.crawler.GetRegionException;
import tech.spiro.addrparser.crawler.RegionDataCrawler;
import tech.spiro.addrparser.io.file.JSONFileRegionDataOutput;

public class CrawlerServer {
    private static Options options = new Options();

    private static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("CrawlerServer", options);
    }

    public static void main(String[] args) throws IOException, GetRegionException {
        DefaultParser parser = new DefaultParser();
        try {
            CommandLine cmd = parser.parse(options, args);
            String level = cmd.getOptionValue('l');
            String code = cmd.getOptionValue('c');
            if (!Arrays.asList("0", "1", "2").contains(level)) {
                throw new ParseException("option:level invalid.");
            }
            String out = cmd.getOptionValue('o');
            int _code = 0;
            try {
                _code = Integer.valueOf(code);
            }
            catch (NumberFormatException e) {
                throw new ParseException("code must be numeric.");
            }
            CrawlerServer.execute(level, _code, out);
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            CrawlerServer.printHelp();
            System.exit(-1);
        }
    }

    private static void execute(String level, int code, String out) throws IOException, GetRegionException {
        try (JSONFileRegionDataOutput regionOutput = new JSONFileRegionDataOutput(out);){
            RegionDataCrawler infoLoader = new RegionDataCrawler(regionOutput);
            if ("0".equals(level)) {
                infoLoader.loadCountry();
            } else if ("1".equals(level)) {
                infoLoader.loadProv(code);
            } else if ("2".equals(level)) {
                infoLoader.loadCity(code);
            }
        }
    }

    static {
        options.addRequiredOption("l", "level", true, "Root region level: 0-country, 1-province, 2-city");
        options.addRequiredOption("c", "code", true, "Root region code");
        options.addRequiredOption("o", "out", true, "Output file.");
    }
}

