/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.parser;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import tech.spiro.addrparser.common.NotImplementedException;
import tech.spiro.addrparser.common.Point;
import tech.spiro.addrparser.common.RegionConverter;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.common.RegionInfo;
import tech.spiro.addrparser.common.RegionLevel;
import tech.spiro.addrparser.io.RegionDataInput;
import tech.spiro.addrparser.parser.Location;
import tech.spiro.addrparser.parser.ParserEngineException;

public class LocationParserEngine {
    private RegionDataInput regionDataInput;
    private Set<RegionInfo> provinceSet = new HashSet<RegionInfo>();
    private Map<Integer, Set<RegionInfo>> provCitySetMap = new HashMap<Integer, Set<RegionInfo>>();
    private Map<Integer, Set<RegionInfo>> cityDistrictSetMap = new HashMap<Integer, Set<RegionInfo>>();

    public LocationParserEngine(RegionDataInput regionDataInput) {
        this.regionDataInput = regionDataInput;
    }

    public void init() throws ParserEngineException {
        try {
            this.regionDataInput.init();
        }
        catch (IOException e) {
            throw new ParserEngineException(e.getMessage(), e);
        }
        try {
            RegionDTO regionDTO;
            while ((regionDTO = this.regionDataInput.read()) != null) {
                this.sortThrough(regionDTO);
            }
        }
        catch (IOException e) {
            throw new ParserEngineException(e.getMessage(), e);
        }
        finally {
            try {
                this.regionDataInput.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void sortThrough(RegionDTO regionDTO) {
        RegionInfo regionInfo = RegionConverter.convert(regionDTO);
        RegionLevel regionLevel = regionInfo.getLevel();
        if (regionLevel == RegionLevel.PROVINCE) {
            this.provinceSet.add(regionInfo);
            return;
        }
        if (regionLevel == RegionLevel.CITY) {
            Integer provCode = regionInfo.getParentCode();
            Set<RegionInfo> provCitySet = this.provCitySetMap.get(provCode);
            if (provCitySet == null) {
                provCitySet = new HashSet<RegionInfo>();
                this.provCitySetMap.put(provCode, provCitySet);
            }
            provCitySet.add(regionInfo);
            return;
        }
        if (regionLevel == RegionLevel.DISTRICT || regionLevel == RegionLevel.STREET) {
            Integer cityCode = regionInfo.getParentCode();
            Set<RegionInfo> cityDistrictSet = this.cityDistrictSetMap.get(cityCode);
            if (cityDistrictSet == null) {
                cityDistrictSet = new HashSet<RegionInfo>();
                this.cityDistrictSetMap.put(cityCode, cityDistrictSet);
            }
            cityDistrictSet.add(regionInfo);
        }
    }

    public Location parse(Point point) {
        if (point == null) {
            throw new IllegalArgumentException("<point> is null.");
        }
        RegionInfo prov = null;
        RegionInfo city = null;
        RegionInfo district = null;
        for (RegionInfo regionInfo : this.provinceSet) {
            if (!regionInfo.contain(point)) continue;
            prov = regionInfo;
            break;
        }
        if (prov == null) {
            return null;
        }
        Integer provCode = prov.getCode();
        Set<RegionInfo> citySet = this.provCitySetMap.get(provCode);
        if (citySet == null) {
            return new Location(prov, null, null);
        }
        for (RegionInfo regionInfo : citySet) {
            if (!regionInfo.contain(point)) continue;
            city = regionInfo;
            break;
        }
        if (city == null) {
            return new Location(prov, null, null);
        }
        Integer cityCode = city.getCode();
        Set<RegionInfo> districtSet = this.cityDistrictSetMap.get(cityCode);
        if (districtSet == null) {
            return new Location(prov, city, null);
        }
        for (RegionInfo regionInfo : districtSet) {
            if (!regionInfo.contain(point)) continue;
            district = regionInfo;
            break;
        }
        return new Location(prov, city, district);
    }

    public Location parse(double lon, double lat) {
        Point point = new Point(lon, lat);
        return this.parse(point);
    }

    public RegionInfo getRegionInfo(int code) {
        throw new NotImplementedException();
    }

    public RegionInfo getRegionInfo(String name) {
        throw new NotImplementedException();
    }

    public List<RegionInfo> getSubRegionInfoList(int code) {
        throw new NotImplementedException();
    }
}

