/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.parser;

import java.awt.Polygon;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import tech.spiro.addrparser.common.ContainPointJudge;
import tech.spiro.addrparser.common.Point;

public class DefaultContainPointJudge
implements ContainPointJudge {
    private Set<Polygon> polygonSet = new HashSet<Polygon>();

    @Override
    public void initPolygons(List<List<Point>> polyline) {
        for (List<Point> points : polyline) {
            Polygon polygon = new Polygon();
            for (Point point : points) {
                polygon.addPoint(this.double2Int(point.getLon()), this.double2Int(point.getLat()));
            }
            polygon.getBounds();
            this.polygonSet.add(polygon);
        }
    }

    @Override
    public boolean contain(Point point) {
        int x = this.double2Int(point.getLon());
        int y = this.double2Int(point.getLat());
        for (Polygon polygon : this.polygonSet) {
            if (!polygon.contains(x, y)) continue;
            return true;
        }
        return false;
    }

    public int double2Int(double d) {
        return new Double(d * 1000000.0).intValue();
    }
}

