/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io.rdbms;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.io.RegionDataOutput;
import tech.spiro.addrparser.io.RegionDataReport;
import tech.spiro.addrparser.io.rdbms.RdbmsRegionDTOWrapper;
import tech.spiro.addrparser.io.rdbms.RdbmsSQL;

public class RdbmsRegionDataOutput
implements RegionDataOutput {
    private static final Logger LOG = LoggerFactory.getLogger(RdbmsRegionDataOutput.class);
    private static final int BATCH_SIZE = 100;
    private DataSource ds = null;
    private Connection conn = null;
    private PreparedStatement stmt = null;
    private int batchCount = 0;
    private RegionDataReport report = new RegionDataReport();
    private boolean initialized = false;
    private final String sql;

    public RdbmsRegionDataOutput(DataSource ds, String tableName) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource:<ds> is null.");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("<tableName> is null.");
        }
        this.ds = ds;
        this.sql = RdbmsSQL.insertSQL(tableName);
    }

    public RdbmsRegionDataOutput(DataSource ds) {
        if (ds == null) {
            throw new IllegalArgumentException("DataSource:<ds> is null.");
        }
        this.ds = ds;
        this.sql = RdbmsSQL.defaultInsertSQL();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        if (this.initialized) {
            return;
        }
        RdbmsRegionDataOutput rdbmsRegionDataOutput = this;
        synchronized (rdbmsRegionDataOutput) {
            if (this.initialized) {
                return;
            }
            LOG.debug("Initializing...sql: {}", (Object)this.sql);
            try {
                this.conn = this.ds.getConnection();
                this.conn.setAutoCommit(false);
            }
            catch (SQLException e) {
                throw new IOException(e.getMessage(), e);
            }
            LOG.debug("Initializing: Get connection completely.");
            try {
                this.stmt = this.conn.prepareStatement(this.sql);
            }
            catch (SQLException e) {
                try {
                    this.conn.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                throw new IOException(e.getMessage(), e);
            }
            LOG.debug("Initializing: Get preparedStatement completely.");
            this.initialized = true;
        }
    }

    @Override
    public void write(RegionDTO regionDTO) throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        if (regionDTO == null) {
            return;
        }
        if (!(regionDTO instanceof RdbmsRegionDTOWrapper)) {
            regionDTO = new RdbmsRegionDTOWrapper(regionDTO);
        }
        RdbmsRegionDTOWrapper wrapper = (RdbmsRegionDTOWrapper)regionDTO;
        this.report.record(wrapper);
        try {
            wrapper.write(this.stmt);
            this.stmt.addBatch();
            ++this.batchCount;
            if (this.batchCount >= 100) {
                this.flushBatch();
            }
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    private void flushBatch() throws SQLException {
        if (this.batchCount == 0) {
            return;
        }
        this.stmt.executeBatch();
        this.conn.commit();
        this.batchCount = 0;
    }

    @Override
    public void close() throws IOException {
        if (!this.initialized) {
            throw new IllegalStateException("Have not initialized already.");
        }
        LOG.info(this.report.report());
        try {
            this.flushBatch();
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        finally {
            try {
                this.stmt.close();
            }
            catch (SQLException sQLException) {}
            try {
                this.conn.close();
            }
            catch (SQLException sQLException) {}
        }
    }
}

