/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io;

import java.util.HashMap;
import java.util.Map;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.common.RegionLevel;

public class RegionDataReport {
    private int totalCount = 0;
    private Map<RegionLevel, Integer> levelCountMap = new HashMap<RegionLevel, Integer>();

    public void record(RegionDTO regionDTO) {
        if (regionDTO == null) {
            return;
        }
        ++this.totalCount;
        RegionLevel regionLevel = regionDTO.getLevel();
        Integer count = this.levelCountMap.get((Object)regionLevel);
        if (count == null) {
            this.levelCountMap.put(regionLevel, 1);
        } else {
            count = count + 1;
            this.levelCountMap.put(regionLevel, count);
        }
    }

    public String report() {
        StringBuilder sb = new StringBuilder("Region Data Report => ");
        sb.append("\n");
        sb.append("totalCount: " + this.totalCount);
        sb.append("\n");
        for (Map.Entry<RegionLevel, Integer> entry : this.levelCountMap.entrySet()) {
            sb.append(entry.getKey().toString() + ": " + entry.getValue());
            sb.append("\n");
        }
        return sb.toString();
    }
}

