/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.io;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.io.RegionDataInput;
import tech.spiro.addrparser.io.RegionDataOutput;

public class IOPipeline {
    private static final Logger LOG = LoggerFactory.getLogger(IOPipeline.class);
    private final RegionDataInput input;
    private final RegionDataOutput output;

    public IOPipeline(RegionDataInput input, RegionDataOutput output) {
        this.input = input;
        this.output = output;
    }

    public void start() throws IOException {
        this.input.init();
        this.output.init();
        try {
            RegionDTO regionDTO;
            while ((regionDTO = this.input.read()) != null) {
                this.output.write(regionDTO);
            }
        }
        finally {
            try {
                this.input.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
            try {
                this.output.close();
            }
            catch (Exception e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

