/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.crawler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.spiro.addrparser.common.RegionDTO;
import tech.spiro.addrparser.common.RegionLevel;
import tech.spiro.addrparser.crawler.DataResp;
import tech.spiro.addrparser.crawler.GetRegionException;
import tech.spiro.addrparser.crawler.RegionResp;
import tech.spiro.addrparser.crawler.RestClient;
import tech.spiro.addrparser.io.RegionDataOutput;

public class RegionDataCrawler {
    private static final Logger LOG = LoggerFactory.getLogger(RegionDataCrawler.class);
    public static final int COUNTRY_CODE = 100000;
    public static final String AMAP_KEY = "b504cbfb3664f21235dd413fc73b44c5";
    private AtomicInteger invokerCount = new AtomicInteger(0);
    private RegionDataOutput regionOutput;

    public RegionDataCrawler() {
    }

    public RegionDataCrawler(RegionDataOutput regionOutput) throws IOException {
        this.regionOutput = regionOutput;
        this.regionOutput.init();
    }

    private List<RegionDTO> getSubRegionDTOs(int code) throws GetRegionException {
        RestClient restClient = new RestClient();
        restClient.setKeywords(Integer.toString(code));
        restClient.setKey(AMAP_KEY);
        restClient.setExtensions("base");
        restClient.setSubdistrict("1");
        DataResp dataResponse = restClient.getDistrictResponse();
        LOG.debug("Invoker.count=" + this.invokerCount.incrementAndGet());
        if (!dataResponse.isSuccess()) {
            throw new GetRegionException("Get failed, infocode=" + dataResponse.getInfocode() + ", info=" + dataResponse.getInfo());
        }
        List<RegionResp> regionResps = dataResponse.getDistricts();
        if (regionResps.isEmpty()) {
            LOG.warn("Have no regionResps return, keyword code={}", (Object)code);
            return null;
        }
        RegionResp curRegionResp = regionResps.get(0);
        List<RegionResp> subRegionResps = curRegionResp.getDistricts();
        ArrayList<RegionDTO> subRegionDTOs = new ArrayList<RegionDTO>();
        if (subRegionResps == null || subRegionResps.isEmpty()) {
            LOG.warn("Have no sub regionResps, {}", (Object)curRegionResp);
        } else {
            for (RegionResp regionResp : subRegionResps) {
                RegionDTO regionDTO = new RegionDTO();
                try {
                    regionDTO.setCode(Integer.valueOf(regionResp.getAdcode()));
                    regionDTO.setLevel(RegionLevel.valueOf(regionResp.getLevel().toUpperCase()));
                    regionDTO.setCenter(regionResp.getCenter());
                    regionDTO.setParentCode(code);
                    regionDTO.setName(regionResp.getName());
                }
                catch (Exception e) {
                    throw new GetRegionException("<regionResp> cannot convert to RegionDTO, maybe regionResp invalid, regionResp:" + regionResp.toString(), e);
                }
                subRegionDTOs.add(regionDTO);
            }
        }
        for (RegionDTO subRegionDTO : subRegionDTOs) {
            RestClient subRestClient = new RestClient();
            subRestClient.setExtensions("all");
            subRestClient.setKey(AMAP_KEY);
            subRestClient.setKeywords(Integer.toString(subRegionDTO.getCode()));
            subRestClient.setSubdistrict("0");
            DataResp subDataResp = subRestClient.getDistrictResponse();
            LOG.debug("Invoker.count=" + this.invokerCount.incrementAndGet());
            if (!subDataResp.isSuccess()) {
                throw new GetRegionException("Get sub district failed");
            }
            List<RegionResp> _subRegionResps = subDataResp.getDistricts();
            if (_subRegionResps.isEmpty()) {
                throw new GetRegionException("Get sub district failed");
            }
            RegionResp _subRegionResp = _subRegionResps.get(0);
            subRegionDTO.setPolyline(_subRegionResp.getPolyline());
        }
        return subRegionDTOs;
    }

    private void regionBatchOutput(List<RegionDTO> regionDTOs) throws GetRegionException {
        try {
            for (RegionDTO regionDTO : regionDTOs) {
                this.regionOutput.write(regionDTO);
            }
        }
        catch (IOException e) {
            throw new GetRegionException(e.getMessage(), e);
        }
    }

    public void loadCountry() throws GetRegionException {
        if (this.regionOutput == null) {
            throw new GetRegionException("<regionOutput> is null.");
        }
        List<RegionDTO> provRegionDTOs = this.getSubRegionDTOs(100000);
        this.regionBatchOutput(provRegionDTOs);
        for (RegionDTO provRegionDTO : provRegionDTOs) {
            this.loadProv(provRegionDTO.getCode());
        }
    }

    public void loadProv(int provCode) throws GetRegionException {
        if (this.regionOutput == null) {
            throw new GetRegionException("<regionOutput> is null.");
        }
        List<RegionDTO> cityRegionDTOs = this.getSubRegionDTOs(provCode);
        this.regionBatchOutput(cityRegionDTOs);
        for (RegionDTO cityRegionDTO : cityRegionDTOs) {
            this.loadCity(cityRegionDTO.getCode());
        }
    }

    public void loadCity(int cityCode) throws GetRegionException {
        if (this.regionOutput == null) {
            throw new GetRegionException("<regionOutput> is null.");
        }
        List<RegionDTO> districtRegionDTOs = this.getSubRegionDTOs(cityCode);
        this.regionBatchOutput(districtRegionDTOs);
    }
}

