/*
 * Decompiled with CFR 0.152.
 */
package tech.spiro.addrparser.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tech.spiro.addrparser.common.ContainPointJudge;
import tech.spiro.addrparser.common.ContainPointJudgeFactory;
import tech.spiro.addrparser.common.Point;
import tech.spiro.addrparser.common.RegionLevel;

public class RegionInfo {
    private final int parentCode;
    private final int code;
    private final String name;
    private final RegionLevel level;
    private final Point center;
    private final List<List<Point>> polyline;
    private final ContainPointJudge containPointJudge = ContainPointJudgeFactory.create();

    private RegionInfo(Builder builder) {
        this.parentCode = builder.parentCode;
        this.code = builder.code;
        this.name = builder.name;
        this.level = builder.level;
        this.center = builder.center;
        this.polyline = Collections.unmodifiableList(builder.polyline);
        this.containPointJudge.initPolygons(this.polyline);
    }

    public int getParentCode() {
        return this.parentCode;
    }

    public int getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public RegionLevel getLevel() {
        return this.level;
    }

    public Point getCenter() {
        return this.center;
    }

    public List<List<Point>> getPolyline() {
        return this.polyline;
    }

    public boolean contain(Point point) {
        return this.containPointJudge.contain(point);
    }

    public String toString() {
        return "RegionInfo{parentCode=" + this.parentCode + ", code=" + this.code + ", name='" + this.name + '\'' + ", level=" + (Object)((Object)this.level) + '}';
    }

    public static class Builder {
        private int parentCode;
        private int code;
        private String name;
        private RegionLevel level;
        private Point center;
        private List<List<Point>> polyline = new ArrayList<List<Point>>();

        public Builder code(int code) {
            this.code = code;
            return this;
        }

        public Builder parentCode(int parentCode) {
            this.parentCode = parentCode;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder level(RegionLevel level) {
            this.level = level;
            return this;
        }

        public Builder center(Point center) {
            this.center = center;
            return this;
        }

        public Builder addPolyline(List<Point> polyline) {
            if (polyline != null && !polyline.isEmpty()) {
                this.polyline.add(Collections.unmodifiableList(polyline));
            }
            return this;
        }

        public RegionInfo build() {
            if (this.name == null) {
                throw new IllegalArgumentException("<name> cannot be null.");
            }
            if (this.level == null) {
                throw new IllegalArgumentException("<level> cannot be null.");
            }
            if (this.center == null) {
                throw new IllegalArgumentException("<center> cannot be null.");
            }
            return new RegionInfo(this);
        }
    }
}

