/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec.bus;

import tech.smartboot.mqtt.common.AbstractSession;
import tech.smartboot.mqtt.common.message.MqttConnAckMessage;
import tech.smartboot.mqtt.common.message.MqttConnectMessage;
import tech.smartboot.mqtt.common.message.MqttMessage;
import tech.smartboot.mqtt.common.message.MqttTopicSubscription;
import tech.smartboot.mqtt.common.message.MqttUnsubscribeMessage;
import tech.smartboot.mqtt.plugin.spec.BrokerContext;
import tech.smartboot.mqtt.plugin.spec.MessageDeliver;
import tech.smartboot.mqtt.plugin.spec.MqttSession;
import tech.smartboot.mqtt.plugin.spec.Options;
import tech.smartboot.mqtt.plugin.spec.bus.EventObject;

public class EventType<T> {
    public static final EventType<AbstractSession> DISCONNECT = new EventType("disconnect");
    public static final EventType<EventObject<MqttMessage>> RECEIVE_MESSAGE = new EventType("receiveMessage");
    public static final EventType<MqttConnAckMessage> RECEIVE_CONN_ACK_MESSAGE = new EventType("connAckMessage");
    public static final EventType<EventObject<MqttMessage>> WRITE_MESSAGE = new EventType("writeMessage");
    public static final EventType<BrokerContext> BROKER_STARTED = new EventType("brokerStarted", true);
    public static final EventType<Options> BROKER_CONFIGURE_LOADED = new EventType("brokerConfigureLoaded", true);
    public static final EventType<BrokerContext> BROKER_DESTROY = new EventType("brokerDestroy", true);
    public static final EventType<MqttSession> SESSION_CREATE = new EventType("sessionCreate");
    public static final EventType<String> TOPIC_CREATE = new EventType("topicCreate");
    public static final EventType<EventObject<MqttTopicSubscription>> SUBSCRIBE_ACCEPT = new EventType("subscribeAccept");
    public static final EventType<EventObject<MqttUnsubscribeMessage>> UNSUBSCRIBE_ACCEPT = new EventType("unsubscribeAccept");
    public static final EventType<EventObject<MessageDeliver>> SUBSCRIBE_TOPIC = new EventType("subscribeTopic");
    public static final EventType<MessageDeliver> UNSUBSCRIBE_TOPIC = new EventType("unsubscribe_topic");
    public static final EventType<MessageDeliver> SUBSCRIBE_REFRESH_TOPIC = new EventType("subscribe_refresh_topic");
    public static final EventType<EventObject<MqttConnectMessage>> CONNECT = new EventType("connect");
    private final String name;
    private final boolean once;

    EventType(String name, boolean once) {
        this.name = name;
        this.once = once;
    }

    EventType(String name) {
        this(name, false);
    }

    public boolean isOnce() {
        return this.once;
    }

    public String toString() {
        return "EventType{name='" + this.name + '\'' + '}';
    }
}

