/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec.bus;

import java.util.List;
import tech.smartboot.mqtt.plugin.spec.bus.EventBusConsumer;
import tech.smartboot.mqtt.plugin.spec.bus.EventType;

public interface EventBus {
    public <T> void subscribe(EventType<T> var1, EventBusConsumer<T> var2);

    default public <T> void subscribe(List<EventType<T>> types, EventBusConsumer<T> subscriber) {
        for (EventType<T> eventType : types) {
            this.subscribe(eventType, subscriber);
        }
    }

    public <T> void publish(EventType<T> var1, T var2);

    default public <T> void publish(EventType<T> eventType, T object, List<EventBusConsumer> subscribers) {
        boolean remove = false;
        for (EventBusConsumer subscriber : subscribers) {
            try {
                if (subscriber.enable()) {
                    subscriber.consumer(eventType, object);
                    continue;
                }
                remove = true;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        if (remove) {
            subscribers.removeIf(eventBusSubscriber -> !eventBusSubscriber.enable());
        }
    }
}

