/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.yaml.snakeyaml.Yaml;
import tech.smartboot.mqtt.plugin.spec.BrokerContext;

public abstract class Plugin {
    public static final String CONFIG_FILE_NAME = "plugin.yaml";
    private File storage;
    private boolean installed;
    private Throwable throwable;

    public String pluginName() {
        return this.getClass().getSimpleName();
    }

    public final void install(BrokerContext brokerContext) throws Throwable {
        this.checkSate();
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(out){

                @Override
                public void print(String x) {
                    super.print("[" + Plugin.this.pluginName() + "] " + x);
                }
            });
            this.initPlugin(brokerContext);
            this.installed = true;
        }
        catch (Throwable e) {
            this.throwable = e;
            throw e;
        }
        finally {
            System.setOut(out);
        }
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    protected void initPlugin(BrokerContext brokerContext) throws Throwable {
    }

    public final void uninstall() {
        PrintStream out = System.out;
        try {
            System.setOut(new PrintStream(out){

                @Override
                public void print(String x) {
                    super.print("[" + Plugin.this.pluginName() + "] " + x);
                }
            });
            this.destroyPlugin();
        }
        finally {
            System.setOut(out);
        }
    }

    protected void destroyPlugin() {
    }

    private void checkSate() {
        if (this.installed) {
            throw new IllegalStateException("plugin [ " + this.pluginName() + " ] has installed!");
        }
    }

    public int order() {
        return 0;
    }

    public File storage() {
        if (this.storage == null) {
            throw new IllegalStateException("plugin [ " + this.pluginName() + " ] has no store directory!");
        }
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }

    public abstract String getVersion();

    public abstract String getVendor();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getDescription() {
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("readme.md");){
            int length;
            if (inputStream == null) {
                String string2 = "readme.md not found";
                return string2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((length = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, length);
            }
            String string = byteArrayOutputStream.toString();
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "readme.md not found";
        }
    }

    public int id() {
        int hashCode = this.pluginName().hashCode();
        return hashCode > 0 ? hashCode : -hashCode;
    }

    public <T> T loadPluginConfig(Class<T> clazz) {
        Yaml yaml = new Yaml();
        return (T)JSONObject.from((Object)yaml.load(this.config())).to(clazz, new JSONReader.Feature[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String config() {
        File file = new File(this.storage(), CONFIG_FILE_NAME);
        if (!file.exists()) {
            return null;
        }
        try (InputStream inputStream = Files.newInputStream(file.toPath(), new OpenOption[0]);){
            int len;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, len);
            }
            String string = byteArrayOutputStream.toString("UTF-8");
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

