/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import java.util.Base64;
import java.util.concurrent.atomic.AtomicInteger;
import tech.smartboot.mqtt.common.ToString;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.enums.PayloadEncodeEnum;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.util.MqttUtil;
import tech.smartboot.mqtt.plugin.spec.BrokerTopic;

public final class Message
extends ToString {
    private final byte[] payload;
    private final BrokerTopic topic;
    private final boolean retained;
    private long offset;
    private final MqttQoS qos;
    private final long createTime = MqttUtil.currentTimeMillis();
    private AtomicInteger pushSemaphore;
    @JSONField(serialize=false)
    private String defaultJson;
    @JSONField(serialize=false)
    private String stringJson;
    @JSONField(serialize=false)
    private String base64Json;

    public Message(MqttPublishMessage message, BrokerTopic topic) {
        this.payload = message.getPayload().getPayload();
        this.retained = message.getFixedHeader().isRetain();
        this.topic = topic;
        this.qos = message.getFixedHeader().getQosLevel();
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public BrokerTopic getTopic() {
        return this.topic;
    }

    public boolean isRetained() {
        return this.retained;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getOffset() {
        return this.offset;
    }

    public MqttQoS getQos() {
        return this.qos;
    }

    public void setOffset(long offset) {
        this.offset = offset;
    }

    public int decrementAndGet() {
        return this.pushSemaphore.decrementAndGet();
    }

    public void setPushSemaphore(int pushSemaphore) {
        this.pushSemaphore = new AtomicInteger(pushSemaphore);
    }

    public String getJsonObject(PayloadEncodeEnum payloadEncodeEnum) {
        if (payloadEncodeEnum == null) {
            payloadEncodeEnum = PayloadEncodeEnum.BYTES;
        }
        switch (payloadEncodeEnum) {
            case STRING: {
                if (this.stringJson == null) {
                    JSONObject json = (JSONObject)JSON.toJSON((Object)((Object)this));
                    json.put((Object)"payload", (Object)new String(this.payload));
                    json.put((Object)"encoding", (Object)payloadEncodeEnum.getCode());
                    this.stringJson = json.toString();
                }
                return this.stringJson;
            }
            case BASE64: {
                if (this.base64Json == null) {
                    JSONObject json = (JSONObject)JSON.toJSON((Object)((Object)this));
                    json.put((Object)"payload", (Object)new String(Base64.getEncoder().encode(this.payload)));
                    json.put((Object)"encoding", (Object)payloadEncodeEnum.getCode());
                    this.base64Json = json.toString();
                }
                return this.base64Json;
            }
        }
        if (this.defaultJson == null) {
            JSONObject json = (JSONObject)JSON.toJSON((Object)((Object)this));
            json.put((Object)"encoding", (Object)payloadEncodeEnum.getCode());
            this.defaultJson = json.toString();
        }
        return this.defaultJson;
    }
}

