/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec;

import tech.smartboot.mqtt.common.enums.MqttMessageType;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.message.MessageBuilder;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.message.variable.MqttPublishVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.PublishProperties;
import tech.smartboot.mqtt.plugin.spec.BrokerTopic;

public final class PublishBuilder
implements MessageBuilder<MqttPublishMessage> {
    private BrokerTopic topic;
    private boolean retained;
    private MqttQoS qos;
    private byte[] payload;
    private int packetId = -1;
    private PublishProperties publishProperties;

    public static PublishBuilder builder() {
        return new PublishBuilder();
    }

    PublishBuilder() {
    }

    public PublishBuilder topic(BrokerTopic topic) {
        this.topic = topic;
        return this;
    }

    public PublishBuilder retained(boolean retained) {
        this.retained = retained;
        return this;
    }

    public PublishBuilder qos(MqttQoS qos) {
        this.qos = qos;
        return this;
    }

    public PublishBuilder payload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public PublishBuilder packetId(int packetId) {
        this.packetId = packetId;
        return this;
    }

    public MqttQoS qos() {
        return this.qos;
    }

    public PublishBuilder publishProperties(PublishProperties publishProperties) {
        this.publishProperties = publishProperties;
        return this;
    }

    public MqttPublishMessage build() {
        MqttPublishVariableHeader mqttVariableHeader = new MqttPublishVariableHeader(this.packetId, this.topic.encodedTopicBytes(), this.publishProperties);
        return new MqttPublishMessage(MqttFixedHeader.getInstance((MqttMessageType)MqttMessageType.PUBLISH, (boolean)false, (int)this.qos.value(), (boolean)this.retained), mqttVariableHeader, this.payload);
    }
}

