/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.smartboot.mqtt.plugin.spec.BrokerContext;

public abstract class Plugin {
    private static final Logger LOGGER = LoggerFactory.getLogger(Plugin.class);
    private File storage;
    private boolean installed;
    private String pluginName;

    public String pluginName() {
        if (this.pluginName == null) {
            this.pluginName = this.getClass().getSimpleName();
        }
        return this.pluginName;
    }

    public final void install(BrokerContext brokerContext) throws Throwable {
        this.checkSate();
        this.initPlugin(brokerContext);
        this.installed = true;
    }

    protected void initPlugin(BrokerContext brokerContext) throws Throwable {
        LOGGER.info("plugin:[" + this.pluginName() + "] do nothing when initPlugin!");
    }

    public final void uninstall() {
        this.destroyPlugin();
    }

    protected void destroyPlugin() {
        LOGGER.info("plugin:[" + this.pluginName() + "] do nothing when destroyPlugin!");
    }

    private void checkSate() {
        if (this.installed) {
            throw new IllegalStateException("plugin [ " + this.pluginName() + " ] has installed!");
        }
    }

    public int order() {
        return 0;
    }

    public File storage() {
        if (this.storage == null) {
            throw new IllegalStateException("plugin [ " + this.pluginName() + " ] has no store directory!");
        }
        return this.storage;
    }

    public void setStorage(File storage) {
        this.storage = storage;
    }
}

