/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.plugin.spec;

import java.io.IOException;
import java.net.InetSocketAddress;
import tech.smartboot.mqtt.common.enums.MqttConnectReturnCode;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttConnAckMessage;
import tech.smartboot.mqtt.common.message.MqttMessage;
import tech.smartboot.mqtt.common.message.variable.MqttConnAckVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ConnectAckProperties;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public interface MqttSession {
    public InetSocketAddress getRemoteAddress() throws IOException;

    public String getClientId();

    public boolean isDisconnect();

    public void disconnect();

    public MqttVersion getMqttVersion();

    public void setAuthorized(boolean var1);

    public boolean isAuthorized();

    public long getLatestReceiveMessageTime();

    public void write(MqttMessage var1, boolean var2);

    default public void write(MqttMessage mqttMessage) {
        this.write(mqttMessage, true);
    }

    public static void connFailAck(MqttConnectReturnCode returnCode, MqttSession session) {
        ValidateUtils.isTrue((returnCode != MqttConnectReturnCode.CONNECTION_ACCEPTED ? 1 : 0) != 0, (String)"");
        ConnectAckProperties properties = null;
        if (session.getMqttVersion() == MqttVersion.MQTT_5) {
            properties = new ConnectAckProperties();
        }
        MqttConnAckMessage badProto = MqttSession.connAck(returnCode, false, properties);
        session.write((MqttMessage)badProto);
        session.disconnect();
    }

    public static MqttConnAckMessage connAck(MqttConnectReturnCode returnCode, boolean sessionPresent, ConnectAckProperties properties) {
        MqttConnAckVariableHeader mqttConnAckVariableHeader = new MqttConnAckVariableHeader(returnCode, sessionPresent, properties);
        return new MqttConnAckMessage(mqttConnAckVariableHeader);
    }
}

