/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.variable.properties;

import java.io.IOException;
import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.Codec;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.variable.properties.MqttProperties;

public class AbstractProperties
extends Codec {
    protected final MqttProperties properties = new MqttProperties();
    private final int validBits;
    private int propertiesLength;

    AbstractProperties(int validBits) {
        this.validBits = validBits;
    }

    public void decode(ByteBuffer buffer) {
        this.properties.decode(buffer, this.validBits);
    }

    @Override
    public final int preEncode() {
        this.propertiesLength = this.properties.preEncode(this.validBits);
        return this.propertiesLength + MqttCodecUtil.getVariableLengthInt(this.propertiesLength);
    }

    @Override
    public final void writeTo(MqttWriter writer) throws IOException {
        MqttCodecUtil.writeVariableLengthInt(writer, this.propertiesLength);
        this.properties.writeTo(writer, this.validBits);
    }
}

