/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.payload;

import java.io.IOException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.payload.MqttPayload;
import tech.smartboot.mqtt.common.message.payload.WillMessage;

public final class MqttConnectPayload
extends MqttPayload {
    private final String clientId;
    private byte[] clientIdBytes;
    private final WillMessage willMessage;
    private final String userName;
    private byte[] userNameBytes;
    private final byte[] password;

    public MqttConnectPayload(String clientId, WillMessage willMessage, String userName, byte[] password) {
        this.clientId = clientId;
        this.willMessage = willMessage;
        this.userName = userName;
        this.password = password;
    }

    public String clientId() {
        return this.clientId;
    }

    public WillMessage getWillMessage() {
        return this.willMessage;
    }

    public String userName() {
        return this.userName;
    }

    public byte[] passwordInBytes() {
        return this.password;
    }

    @Override
    protected int preEncode() {
        int length = 0;
        this.clientIdBytes = MqttCodecUtil.encodeUTF8(this.clientId);
        length += this.clientIdBytes.length;
        if (this.willMessage != null) {
            this.willMessage.check();
            length += this.willMessage.preEncode();
        }
        if (this.userName != null) {
            this.userNameBytes = MqttCodecUtil.encodeUTF8(this.userName);
            length += this.userNameBytes.length;
        }
        if (this.password != null) {
            length += 2 + this.password.length;
        }
        return length;
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        mqttWriter.write(this.clientIdBytes);
        if (this.willMessage != null) {
            this.willMessage.writeTo(mqttWriter);
        }
        if (this.userNameBytes != null) {
            mqttWriter.write(this.userNameBytes);
        }
        if (this.password != null) {
            MqttCodecUtil.writeMsbLsb(mqttWriter, this.password.length);
            mqttWriter.write(this.password);
        }
    }
}

