/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttPacketIdentifierMessage;
import tech.smartboot.mqtt.common.message.payload.MqttPublishPayload;
import tech.smartboot.mqtt.common.message.variable.MqttPublishVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.PublishProperties;
import tech.smartboot.mqtt.common.util.TopicByteTree;

public class MqttPublishMessage
extends MqttPacketIdentifierMessage<MqttPublishVariableHeader> {
    private static final MqttPublishPayload EMPTY_BYTES = new MqttPublishPayload(new byte[0]);
    private MqttPublishPayload payload;

    public MqttPublishMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    public MqttPublishMessage(MqttFixedHeader mqttFixedHeader, MqttPublishVariableHeader mqttPublishVariableHeader, byte[] payload) {
        super(mqttFixedHeader);
        this.setVariableHeader(mqttPublishVariableHeader);
        this.payload = new MqttPublishPayload(payload);
    }

    @Override
    public void decodeVariableHeader0(ByteBuffer buffer) {
        MqttPublishVariableHeader variableHeader;
        String topic = TopicByteTree.DEFAULT_INSTANCE.search(buffer);
        int packetId = -1;
        if (this.fixedHeader.getQosLevel().value() > 0) {
            packetId = this.decodeMessageId(buffer);
        }
        if (this.version == MqttVersion.MQTT_5) {
            PublishProperties properties = new PublishProperties();
            properties.decode(buffer);
            variableHeader = new MqttPublishVariableHeader(packetId, topic, properties);
        } else {
            variableHeader = new MqttPublishVariableHeader(packetId, topic, null);
        }
        this.setVariableHeader(variableHeader);
    }

    @Override
    public void decodePlayLoad(ByteBuffer buffer) {
        int readLength = this.getRemainingLength() - this.getVariableHeaderLength();
        if (readLength == 0) {
            this.payload = EMPTY_BYTES;
        } else {
            byte[] bytes = new byte[readLength];
            buffer.get(bytes);
            this.payload = new MqttPublishPayload(bytes);
        }
    }

    @Override
    public MqttPublishPayload getPayload() {
        return this.payload;
    }
}

