/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttPacketIdentifierMessage;
import tech.smartboot.mqtt.common.message.variable.MqttPubQosVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ReasonProperties;

public class MqttPubQosMessage
extends MqttPacketIdentifierMessage<MqttPubQosVariableHeader> {
    public MqttPubQosMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    public MqttPubQosMessage(MqttFixedHeader pubRecHeader, MqttPubQosVariableHeader variableHeader) {
        super(pubRecHeader);
        this.variableHeader = variableHeader;
    }

    @Override
    protected final void decodeVariableHeader0(ByteBuffer buffer) {
        int packetId = this.decodeMessageId(buffer);
        MqttPubQosVariableHeader header = null;
        if (this.version == MqttVersion.MQTT_5) {
            byte reasonCode = 0;
            if (this.getRemainingLength() > 2) {
                reasonCode = buffer.get();
            }
            if (this.getRemainingLength() >= 4) {
                ReasonProperties properties = new ReasonProperties();
                properties.decode(buffer);
                header = new MqttPubQosVariableHeader(packetId, properties);
            } else {
                header = new MqttPubQosVariableHeader(packetId, null);
                header.setReasonCode(reasonCode);
            }
        } else {
            header = new MqttPubQosVariableHeader(packetId, null);
        }
        this.setVariableHeader(header);
    }
}

