/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.io.IOException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.enums.MqttMessageType;
import tech.smartboot.mqtt.common.enums.MqttQoS;

public class MqttFixedHeader {
    public static final MqttFixedHeader CONNECT_HEADER = new MqttFixedHeader(MqttMessageType.CONNECT, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader CONN_ACK_HEADER = new MqttFixedHeader(MqttMessageType.CONNACK, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader PUB_ACK_HEADER = new MqttFixedHeader(MqttMessageType.PUBACK, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader PUB_REC_HEADER = new MqttFixedHeader(MqttMessageType.PUBREC, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader PUB_REL_HEADER = new MqttFixedHeader(MqttMessageType.PUBREL, MqttQoS.AT_LEAST_ONCE);
    public static final MqttFixedHeader PUB_REL_HEADER_DUP = new MqttFixedHeader(MqttMessageType.PUBREL, true, MqttQoS.AT_LEAST_ONCE, false);
    public static final MqttFixedHeader PUB_COMP_HEADER = new MqttFixedHeader(MqttMessageType.PUBCOMP, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader SUBSCRIBE_HEADER = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, MqttQoS.AT_LEAST_ONCE);
    public static final MqttFixedHeader SUBSCRIBE_HEADER_DUP = new MqttFixedHeader(MqttMessageType.SUBSCRIBE, true, MqttQoS.AT_LEAST_ONCE, false);
    public static final MqttFixedHeader SUB_ACK_HEADER = new MqttFixedHeader(MqttMessageType.SUBACK, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader UNSUBSCRIBE_HEADER = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, MqttQoS.AT_LEAST_ONCE);
    public static final MqttFixedHeader UNSUBSCRIBE_HEADER_DUP = new MqttFixedHeader(MqttMessageType.UNSUBSCRIBE, true, MqttQoS.AT_LEAST_ONCE, false);
    public static final MqttFixedHeader UNSUB_ACK_HEADER = new MqttFixedHeader(MqttMessageType.UNSUBACK, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader PING_REQ_HEADER = new MqttFixedHeader(MqttMessageType.PINGREQ, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader PING_RESP_HEADER = new MqttFixedHeader(MqttMessageType.PINGRESP, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader DISCONNECT_HEADER = new MqttFixedHeader(MqttMessageType.DISCONNECT, MqttQoS.AT_MOST_ONCE);
    public static final MqttFixedHeader PUB_QOS0_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_MOST_ONCE, false);
    public static final MqttFixedHeader PUB_RETAIN_QOS0_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_MOST_ONCE, true);
    public static final MqttFixedHeader PUB_QOS1_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, false);
    public static final MqttFixedHeader PUB_RETAIN_QOS1_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.AT_LEAST_ONCE, true);
    public static final MqttFixedHeader PUB_QOS2_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.EXACTLY_ONCE, false);
    public static final MqttFixedHeader PUB_RETAIN_QOS2_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.EXACTLY_ONCE, true);
    public static final MqttFixedHeader PUB_FAILURE_HEADER = new MqttFixedHeader(MqttMessageType.PUBLISH, false, MqttQoS.FAILURE, false);
    private final MqttMessageType messageType;
    private final boolean dup;
    private final MqttQoS qosLevel;
    private final boolean retain;
    private final byte encodeByte;

    private MqttFixedHeader(MqttMessageType messageType, boolean dup, MqttQoS qosLevel, boolean retain) {
        this.messageType = messageType;
        this.dup = dup;
        this.qosLevel = qosLevel;
        this.retain = retain;
        this.encodeByte = this.encodeByte();
    }

    private MqttFixedHeader(MqttMessageType messageType, MqttQoS qosLevel) {
        this(messageType, false, qosLevel, false);
    }

    private byte encodeByte() {
        int ret = 0;
        ret |= this.messageType.value() << 4;
        if (this.dup) {
            ret |= 8;
        }
        ret |= this.qosLevel.value() << 1;
        if (this.retain) {
            ret |= 1;
        }
        return (byte)ret;
    }

    public void writeTo(MqttWriter mqttWriter) throws IOException {
        mqttWriter.writeByte(this.encodeByte);
    }

    public static MqttFixedHeader getInstance(MqttMessageType messageType, boolean dup, int qosLevel, boolean retain) {
        switch (messageType) {
            case CONNECT: {
                return CONNECT_HEADER;
            }
            case CONNACK: {
                return CONN_ACK_HEADER;
            }
            case SUBSCRIBE: {
                return dup ? SUBSCRIBE_HEADER_DUP : SUBSCRIBE_HEADER;
            }
            case SUBACK: {
                return SUB_ACK_HEADER;
            }
            case UNSUBACK: {
                return UNSUB_ACK_HEADER;
            }
            case UNSUBSCRIBE: {
                return dup ? UNSUBSCRIBE_HEADER_DUP : UNSUBSCRIBE_HEADER;
            }
            case PUBLISH: {
                if (dup) {
                    return new MqttFixedHeader(messageType, true, MqttQoS.valueOf(qosLevel), retain);
                }
                switch (qosLevel) {
                    case 0: {
                        return retain ? PUB_RETAIN_QOS0_HEADER : PUB_QOS0_HEADER;
                    }
                    case 1: {
                        return retain ? PUB_RETAIN_QOS1_HEADER : PUB_QOS1_HEADER;
                    }
                    case 2: {
                        return retain ? PUB_RETAIN_QOS2_HEADER : PUB_QOS2_HEADER;
                    }
                }
                return PUB_FAILURE_HEADER;
            }
            case PUBACK: {
                return PUB_ACK_HEADER;
            }
            case PUBREC: {
                return PUB_REC_HEADER;
            }
            case PUBREL: {
                return dup ? PUB_REL_HEADER_DUP : PUB_REL_HEADER;
            }
            case PUBCOMP: {
                return PUB_COMP_HEADER;
            }
            case PINGREQ: {
                return PING_REQ_HEADER;
            }
            case PINGRESP: {
                return PING_RESP_HEADER;
            }
            case DISCONNECT: {
                return DISCONNECT_HEADER;
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)messageType));
    }

    public MqttMessageType getMessageType() {
        return this.messageType;
    }

    public boolean isDup() {
        return this.dup;
    }

    public MqttQoS getQosLevel() {
        return this.qosLevel;
    }

    public boolean isRetain() {
        return this.retain;
    }
}

