/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.enums.MqttProtocolEnum;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttVariableMessage;
import tech.smartboot.mqtt.common.message.payload.MqttConnectPayload;
import tech.smartboot.mqtt.common.message.payload.WillMessage;
import tech.smartboot.mqtt.common.message.variable.MqttConnectVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ConnectProperties;
import tech.smartboot.mqtt.common.message.variable.properties.WillProperties;
import tech.smartboot.mqtt.common.util.TopicByteTree;

public class MqttConnectMessage
extends MqttVariableMessage<MqttConnectVariableHeader> {
    private MqttConnectPayload mqttConnectPayload;

    public MqttConnectMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    public MqttConnectMessage(MqttConnectVariableHeader mqttConnectVariableHeader, MqttConnectPayload mqttConnectPayload) {
        super(MqttFixedHeader.CONNECT_HEADER);
        this.setVariableHeader(mqttConnectVariableHeader);
        this.mqttConnectPayload = mqttConnectPayload;
    }

    @Override
    public void decodeVariableHeader0(ByteBuffer buffer) {
        MqttConnectVariableHeader variableHeader;
        String protocolName = MqttCodecUtil.decodeUTF8(buffer);
        byte protocolLevel = buffer.get();
        int b1 = buffer.get() & 0xFF;
        int keepAlive = MqttCodecUtil.decodeMsbLsb(buffer);
        this.version = MqttVersion.getByProtocolWithVersion(MqttProtocolEnum.getByName(protocolName), protocolLevel);
        if (this.version == MqttVersion.MQTT_5) {
            ConnectProperties properties = new ConnectProperties();
            properties.decode(buffer);
            variableHeader = new MqttConnectVariableHeader(protocolName, protocolLevel, b1, keepAlive, properties);
        } else {
            variableHeader = new MqttConnectVariableHeader(protocolName, protocolLevel, b1, keepAlive, null);
        }
        this.setVariableHeader(variableHeader);
    }

    @Override
    public void decodePlayLoad(ByteBuffer buffer) {
        MqttConnectVariableHeader variableHeader = (MqttConnectVariableHeader)this.getVariableHeader();
        String decodedClientId = MqttCodecUtil.decodeUTF8(buffer);
        WillMessage willMessage = null;
        if (variableHeader.isWillFlag()) {
            willMessage = new WillMessage();
            if (this.version == MqttVersion.MQTT_5) {
                WillProperties willProperties = new WillProperties();
                willProperties.decode(buffer);
                willMessage.setProperties(willProperties);
            }
            willMessage.setTopic(TopicByteTree.DEFAULT_INSTANCE.search(buffer));
            willMessage.setPayload(MqttCodecUtil.decodeByteArray(buffer));
        }
        String decodedUserName = null;
        byte[] decodedPassword = null;
        if (variableHeader.hasUserName()) {
            decodedUserName = MqttCodecUtil.decodeUTF8(buffer);
        }
        if (variableHeader.hasPassword()) {
            decodedPassword = MqttCodecUtil.decodeByteArray(buffer);
        }
        this.mqttConnectPayload = new MqttConnectPayload(decodedClientId, willMessage, decodedUserName, decodedPassword);
    }

    @Override
    public MqttConnectPayload getPayload() {
        return this.mqttConnectPayload;
    }
}

