/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.enums.MqttConnectReturnCode;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttVariableMessage;
import tech.smartboot.mqtt.common.message.variable.MqttConnAckVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ConnectAckProperties;

public class MqttConnAckMessage
extends MqttVariableMessage<MqttConnAckVariableHeader> {
    public MqttConnAckMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    public MqttConnAckMessage(MqttConnAckVariableHeader mqttConnAckVariableHeader) {
        super(MqttFixedHeader.CONN_ACK_HEADER);
        this.setVariableHeader(mqttConnAckVariableHeader);
    }

    @Override
    public void decodeVariableHeader0(ByteBuffer buffer) {
        MqttConnAckVariableHeader variableHeader;
        boolean sessionPresent = (buffer.get() & 1) == 1;
        byte returnCode = buffer.get();
        if (this.version == MqttVersion.MQTT_5) {
            ConnectAckProperties properties = new ConnectAckProperties();
            properties.decode(buffer);
            variableHeader = new MqttConnAckVariableHeader(MqttConnectReturnCode.valueOf(returnCode), sessionPresent, properties);
        } else {
            variableHeader = new MqttConnAckVariableHeader(MqttConnectReturnCode.valueOf(returnCode), sessionPresent, null);
        }
        this.setVariableHeader(variableHeader);
    }
}

