/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.enums;

public enum MqttDisConnectReturnCode {
    NORMAL_DISCONNECT(0, "\u6b63\u5e38\u65ad\u5f00"),
    DISCONNECT_WITH_WILL_MESSAGE(4, "\u5305\u542b\u9057\u5631\u6d88\u606f\u7684\u65ad\u5f00"),
    UNSPECIFIED_ERROR(-128, "\u672a\u6307\u5b9a\u9519\u8bef"),
    MALFORMED_PACKET(-127, "\u65e0\u6548\u7684\u62a5\u6587"),
    PROTOCOL_ERROR(-126, "\u534f\u8bae\u9519\u8bef"),
    IMPLEMENTATION_SPECIFIC_ERROR(-125, "\u5b9e\u73b0\u6307\u5b9a\u9519\u8bef"),
    NOT_AUTHORIZED(-121, "\u672a\u6388\u6743"),
    SERVER_BUSY(-119, "\u670d\u52a1\u7aef\u6b63\u5fd9"),
    SERVER_SHUTTING_DOWN(-117, "\u670d\u52a1\u6b63\u5173\u95ed"),
    KEEP_ALIVE_TIMEOUT(-115, "\u4fdd\u6301\u8fde\u63a5\u8d85\u65f6"),
    SESSION_TAKEN_OVER(-114, "\u4f1a\u8bdd\u88ab\u63a5\u7ba1"),
    TOPIC_FILTER_INVALID(-113, "\u4e3b\u9898\u8fc7\u6ee4\u5668\u65e0\u6548"),
    TOPIC_NAME_INVALID(-112, "\u4e3b\u9898\u540d\u65e0\u6548"),
    RECEIVE_MAXIMUM_EXCEEDED(-109, "\u8d85\u51fa\u63a5\u6536\u6700\u5927\u503c"),
    TOPIC_ALIAS_INVALID(-108, "\u4e3b\u9898\u522b\u540d\u65e0\u6548"),
    PACKET_TOO_LARGE(-107, "\u62a5\u6587\u8fc7\u5927"),
    MESSAGE_RATE_TOO_HIGH(-106, "\u6d88\u606f\u901f\u7387\u8fc7\u9ad8"),
    QUOTA_EXCEEDED(-105, "\u8d85\u51fa\u914d\u989d"),
    ADMINISTRATIVE_ACTION(-104, "\u7ba1\u7406\u64cd\u4f5c"),
    PAYLOAD_FORMAT_INVALID(-103, "\u8f7d\u8377\u683c\u5f0f\u65e0\u6548"),
    RETAIN_NOT_SUPPORTED(-102, "\u4e0d\u652f\u6301\u4fdd\u7559"),
    QOS_NOT_SUPPORTED(-101, "\u4e0d\u652f\u6301\u7684QoS\u7b49\u7ea7"),
    USE_ANOTHER_SERVER(-100, "\uff08\u4e34\u65f6\uff09\u4f7f\u7528\u5176\u4ed6\u670d\u52a1\u7aef"),
    SERVER_MOVED(-99, "\u670d\u52a1\u7aef\u5df2\uff08\u6c38\u4e45\uff09\u79fb\u52a8"),
    SHARED_SUBSCRIPTIONS_NOT_SUPPORTED(-98, "\u4e0d\u652f\u6301\u5171\u4eab\u8ba2\u9605"),
    CONNECTION_RATE_EXCEEDED(-97, "\u8d85\u51fa\u8fde\u63a5\u901f\u7387\u9650\u5236"),
    MAXIMUM_CONNECT_TIME(-96, "\u6700\u5927\u8fde\u63a5\u65f6\u95f4"),
    SUBSCRIPTION_IDENTIFIERS_NOT_SUPPORTED(-95, "\u4e0d\u652f\u6301\u8ba2\u9605\u6807\u8bc6\u7b26"),
    WILDCARD_SUBSCRIPTIONS_NOT_SUPPORTED(-94, "\u4e0d\u652f\u6301\u901a\u914d\u7b26\u8ba2\u9605");

    private final byte code;
    private final String desc;
    private static final MqttDisConnectReturnCode[] values;

    private MqttDisConnectReturnCode(byte code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static MqttDisConnectReturnCode valueOf(byte b) {
        for (MqttDisConnectReturnCode v : values) {
            if (b != v.code) continue;
            return v;
        }
        throw new IllegalArgumentException("unknown connect return code: " + (b & 0xFF));
    }

    public byte getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        values = MqttDisConnectReturnCode.values();
    }
}

