/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

public class TopicNode {
    public static final TopicNode WILDCARD_HASH_NODE = new TopicNode(0, 1, "#");
    public static final TopicNode WILDCARD_PLUS_NODE = new TopicNode(0, 1, "+");
    public static final TopicNode SHARE_NODE = new TopicNode(0, "$share".length(), "$share");
    private final int begin;
    private final int end;
    private final String node;
    private int hash;

    public TopicNode(int begin, int end, String node) {
        this.begin = begin;
        this.end = end;
        this.node = node;
    }

    public boolean contains(char c) {
        for (int i = this.begin; i < this.end; ++i) {
            if (this.node.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    public int length() {
        return this.end - this.begin;
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0 && this.length() > 0) {
            int i = this.begin;
            int j = 0;
            while (i < this.end) {
                h = 31 * h + this.node.charAt(i);
                ++i;
                ++j;
            }
            this.hash = h;
        }
        return h;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof TopicNode) {
            TopicNode anotherString = (TopicNode)obj;
            int n = this.length();
            if (n == anotherString.length()) {
                int i = this.begin;
                int j = anotherString.begin;
                while (i < this.end) {
                    if (this.node.charAt(i) != anotherString.node.charAt(j)) {
                        return false;
                    }
                    ++i;
                    ++j;
                }
                return true;
            }
        }
        return false;
    }
}

