/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import java.nio.ByteBuffer;
import tech.smartboot.mqtt.common.AbstractSession;
import tech.smartboot.mqtt.common.Decoder;
import tech.smartboot.mqtt.common.MqttProtocol;
import tech.smartboot.mqtt.common.util.ValidateUtils;

final class MqttPayloadDecoder
implements Decoder {
    MqttPayloadDecoder() {
    }

    @Override
    public Decoder decode(ByteBuffer buffer, AbstractSession session) {
        ByteBuffer payloadBuffer;
        int remainingLength = session.mqttMessage.getRemainingLength();
        if (remainingLength > buffer.capacity()) {
            if (session.disposableBuffer == null) {
                payloadBuffer = session.disposableBuffer = ByteBuffer.allocate(remainingLength);
            } else {
                payloadBuffer = session.disposableBuffer;
                payloadBuffer.compact();
            }
            if (payloadBuffer.remaining() >= buffer.remaining()) {
                payloadBuffer.put(buffer);
            } else {
                int limit = buffer.limit();
                buffer.limit(buffer.position() + payloadBuffer.remaining());
                payloadBuffer.put(buffer);
                buffer.limit(limit);
            }
            payloadBuffer.flip();
        } else {
            payloadBuffer = buffer;
        }
        if (payloadBuffer.remaining() < remainingLength) {
            return this;
        }
        int p = payloadBuffer.position();
        session.mqttMessage.decodeVariableHeader(payloadBuffer);
        session.mqttMessage.decodePlayLoad(payloadBuffer);
        ValidateUtils.isTrue(payloadBuffer.position() - p == remainingLength, "Payload size is wrong");
        session.disposableBuffer = null;
        return MqttProtocol.FINISH_DECODER;
    }
}

