/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import java.nio.ByteBuffer;
import org.smartboot.socket.DecoderException;
import tech.smartboot.mqtt.common.AbstractSession;
import tech.smartboot.mqtt.common.Decoder;
import tech.smartboot.mqtt.common.MqttPayloadDecoder;
import tech.smartboot.mqtt.common.enums.MqttMessageType;
import tech.smartboot.mqtt.common.message.MqttConnAckMessage;
import tech.smartboot.mqtt.common.message.MqttConnectMessage;
import tech.smartboot.mqtt.common.message.MqttDisconnectMessage;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttMessage;
import tech.smartboot.mqtt.common.message.MqttPingReqMessage;
import tech.smartboot.mqtt.common.message.MqttPingRespMessage;
import tech.smartboot.mqtt.common.message.MqttPubAckMessage;
import tech.smartboot.mqtt.common.message.MqttPubCompMessage;
import tech.smartboot.mqtt.common.message.MqttPubRecMessage;
import tech.smartboot.mqtt.common.message.MqttPubRelMessage;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.message.MqttSubAckMessage;
import tech.smartboot.mqtt.common.message.MqttSubscribeMessage;
import tech.smartboot.mqtt.common.message.MqttUnsubAckMessage;
import tech.smartboot.mqtt.common.message.MqttUnsubscribeMessage;

final class MqttHeaderDecoder
implements Decoder {
    private final MqttPayloadDecoder mqttPayloadDecoder = new MqttPayloadDecoder();
    private final int maxBytesInMessage;

    public MqttHeaderDecoder(int maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    @Override
    public Decoder decode(ByteBuffer buffer, AbstractSession session) {
        byte digit;
        if (buffer.remaining() < 2) {
            return this;
        }
        buffer.mark();
        byte b1 = buffer.get();
        MqttMessageType messageType = MqttMessageType.valueOf((b1 & 0xFF) >> 4);
        int remainingLength = 0;
        int multiplier = 1;
        int loops = 0;
        while (((digit = buffer.get()) & 0x80) != 0) {
            remainingLength += (digit & 0x7F) * multiplier;
            if (++loops == 4) {
                throw new DecoderException("remaining length exceeds 4 digits (" + (Object)((Object)messageType) + ')');
            }
            if (!buffer.hasRemaining()) {
                buffer.reset();
                return this;
            }
            multiplier <<= 7;
        }
        buffer.mark();
        if ((remainingLength += digit * multiplier) > this.maxBytesInMessage) {
            throw new DecoderException("too large message: " + remainingLength + " bytes");
        }
        boolean dupFlag = (b1 & 8) == 8;
        int qosLevel = (b1 & 6) >> 1;
        boolean retain = (b1 & 1) != 0;
        MqttFixedHeader mqttFixedHeader = MqttFixedHeader.getInstance(messageType, dupFlag, qosLevel, retain);
        session.mqttMessage = this.newMessage(mqttFixedHeader);
        session.mqttMessage.setRemainingLength(remainingLength);
        if (session.mqttMessage.getVersion() == null) {
            session.mqttMessage.setVersion(session.getMqttVersion());
        }
        return this.mqttPayloadDecoder.decode(buffer, session);
    }

    private MqttMessage newMessage(MqttFixedHeader mqttFixedHeader) {
        switch (mqttFixedHeader.getMessageType()) {
            case CONNECT: {
                return new MqttConnectMessage(mqttFixedHeader);
            }
            case CONNACK: {
                return new MqttConnAckMessage(mqttFixedHeader);
            }
            case SUBSCRIBE: {
                return new MqttSubscribeMessage(mqttFixedHeader);
            }
            case SUBACK: {
                return new MqttSubAckMessage(mqttFixedHeader);
            }
            case UNSUBACK: {
                return new MqttUnsubAckMessage(mqttFixedHeader);
            }
            case UNSUBSCRIBE: {
                return new MqttUnsubscribeMessage(mqttFixedHeader);
            }
            case PUBLISH: {
                return new MqttPublishMessage(mqttFixedHeader);
            }
            case PUBACK: {
                return new MqttPubAckMessage(mqttFixedHeader);
            }
            case PUBREC: {
                return new MqttPubRecMessage(mqttFixedHeader);
            }
            case PUBREL: {
                return new MqttPubRelMessage(mqttFixedHeader);
            }
            case PUBCOMP: {
                return new MqttPubCompMessage(mqttFixedHeader);
            }
            case PINGREQ: {
                return new MqttPingReqMessage(mqttFixedHeader);
            }
            case PINGRESP: {
                return new MqttPingRespMessage(mqttFixedHeader);
            }
            case DISCONNECT: {
                return new MqttDisconnectMessage();
            }
        }
        throw new IllegalArgumentException("unknown message type: " + (Object)((Object)mqttFixedHeader.getMessageType()));
    }
}

