/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.util;

import java.lang.reflect.Field;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.smartboot.socket.timer.HashedWheelTimer;
import tech.smartboot.mqtt.common.TopicToken;
import tech.smartboot.mqtt.common.exception.MqttException;

public class MqttUtil {
    private static final char[] TOPIC_WILDCARDS = new char[]{'#', '+'};
    private static long currentTimeMillis = System.currentTimeMillis();

    public static long currentTimeMillis() {
        return currentTimeMillis;
    }

    public static boolean containsTopicWildcards(String topicName) {
        for (char c : TOPIC_WILDCARDS) {
            if (topicName.indexOf(c) < 0) continue;
            return true;
        }
        return false;
    }

    public static String createClientId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public static boolean match(TopicToken pubTopicToken, TopicToken subTopicToken) {
        if (subTopicToken == null) {
            return pubTopicToken == null;
        }
        if ("#".equals(subTopicToken.getNode())) {
            return true;
        }
        if ("+".equals(subTopicToken.getNode())) {
            return pubTopicToken != null && MqttUtil.match(pubTopicToken.getNextNode(), subTopicToken.getNextNode());
        }
        if (pubTopicToken == null || !pubTopicToken.getNode().equals(subTopicToken.getNode())) {
            return false;
        }
        return MqttUtil.match(pubTopicToken.getNextNode(), subTopicToken.getNextNode());
    }

    public static void updateConfig(Object config, String prefix) {
        try {
            for (Field field : config.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                String v = System.getProperty(prefix + "." + field.getName());
                if (v == null) {
                    v = System.getenv((prefix + "." + field.getName()).replace(".", "_").toUpperCase());
                }
                if (v == null) continue;
                Class<?> type = field.getType();
                if (type == Integer.TYPE) {
                    field.set(config, Integer.parseInt(v));
                    continue;
                }
                if (type == String.class) {
                    field.set(config, v);
                    continue;
                }
                throw new UnsupportedOperationException();
            }
        }
        catch (Throwable throwable) {
            throw new MqttException("update config exception", throwable);
        }
    }

    public static int toInt(String str) {
        return MqttUtil.toInt(str, 0);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException var3) {
            return defaultValue;
        }
    }

    public static boolean isNotBlank(CharSequence cs) {
        return !MqttUtil.isBlank(cs);
    }

    public static boolean isBlank(CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(cs.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String defaultString(String str) {
        return MqttUtil.defaultString(str, "");
    }

    public static String defaultString(String str, String defaultStr) {
        return str == null ? defaultStr : str;
    }

    static {
        HashedWheelTimer.DEFAULT_TIMER.scheduleWithFixedDelay(() -> {
            currentTimeMillis = System.currentTimeMillis();
        }, 1L, TimeUnit.SECONDS);
    }
}

