/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.variable.properties;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.variable.properties.UserProperty;
import tech.smartboot.mqtt.common.util.MqttPropertyConstant;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public class MqttProperties {
    private String authenticationMethod;
    private byte[] authenticationMethodBytes;
    private int sessionExpiryInterval;
    private int subscriptionIdentifier;
    private int willDelayInterval;
    private byte payloadFormatIndicator;
    private int messageExpiryInterval;
    private String contentType;
    private byte[] contentTypeBytes;
    private String responseTopic;
    private byte[] responseTopicBytes;
    private byte[] correlationData;
    private String assignedClientIdentifier;
    private byte[] assignedClientIdentifierBytes;
    private int serverKeepAlive;
    private final List<UserProperty> userProperties = new ArrayList<UserProperty>();
    private byte requestProblemInformation = 1;
    private byte[] authenticationData;
    private byte requestResponseInformation;
    private String responseInformation;
    private byte[] responseInformationBytes;
    private String serverReference;
    private byte[] serverReferenceBytes;
    private String reasonString;
    private byte[] reasonStringBytes;
    private int topicAliasMaximum;
    private int receiveMaximum = 65535;
    private int topicAlias;
    private byte maximumQoS = (byte)-1;
    private byte retainAvailable = 1;
    private int maximumPacketSize;
    private byte wildcardSubscriptionAvailable = 1;
    private byte subscriptionIdentifierAvailable = 1;
    private byte sharedSubscriptionAvailable = 1;

    public void decode(ByteBuffer buffer, int validBites) {
        int position;
        block29: for (int remainingLength = MqttCodecUtil.decodeVariableByteInteger(buffer); remainingLength > 0; remainingLength -= buffer.position() - position) {
            position = buffer.position();
            switch (buffer.get()) {
                case 1: {
                    ValidateUtils.isTrue((MqttPropertyConstant.PAYLOAD_FORMAT_INDICATOR_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.PAYLOAD_FORMAT_INDICATOR_BIT;
                    this.payloadFormatIndicator = buffer.get();
                    ValidateUtils.isTrue(this.payloadFormatIndicator == 0 || this.payloadFormatIndicator == 1, "");
                    continue block29;
                }
                case 2: {
                    ValidateUtils.isTrue((MqttPropertyConstant.MESSAGE_EXPIRY_INTERVAL_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.MESSAGE_EXPIRY_INTERVAL_BIT;
                    ValidateUtils.isTrue(this.messageExpiryInterval == -1, "");
                    this.messageExpiryInterval = buffer.getInt();
                    ValidateUtils.isTrue(this.messageExpiryInterval > 0, "");
                    continue block29;
                }
                case 3: {
                    ValidateUtils.isTrue((MqttPropertyConstant.CONTENT_TYPE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.CONTENT_TYPE_BIT;
                    this.contentType = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 8: {
                    ValidateUtils.isTrue((MqttPropertyConstant.RESPONSE_TOPIC_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.RESPONSE_TOPIC_BIT;
                    this.responseTopic = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 9: {
                    ValidateUtils.isTrue((MqttPropertyConstant.CORRELATION_DATA_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.CORRELATION_DATA_BIT;
                    this.correlationData = MqttCodecUtil.decodeByteArray(buffer);
                    continue block29;
                }
                case 11: {
                    ValidateUtils.isTrue((MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_BIT;
                    this.subscriptionIdentifier = MqttCodecUtil.decodeVariableByteInteger(buffer);
                    ValidateUtils.isTrue(this.subscriptionIdentifier >= 1 && this.subscriptionIdentifier <= 0xFFFFFFF, "");
                    continue block29;
                }
                case 17: {
                    ValidateUtils.isTrue((MqttPropertyConstant.SESSION_EXPIRY_INTERVAL_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.SESSION_EXPIRY_INTERVAL_BIT;
                    this.sessionExpiryInterval = buffer.getInt();
                    continue block29;
                }
                case 18: {
                    ValidateUtils.isTrue((MqttPropertyConstant.ASSIGNED_CLIENT_IDENTIFIER_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.ASSIGNED_CLIENT_IDENTIFIER_BIT;
                    this.assignedClientIdentifier = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 19: {
                    ValidateUtils.isTrue((MqttPropertyConstant.SERVER_KEEP_ALIVE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.SERVER_KEEP_ALIVE_BIT;
                    this.serverKeepAlive = MqttCodecUtil.decodeMsbLsb(buffer);
                    ValidateUtils.isTrue(this.serverKeepAlive >= 0, "");
                    continue block29;
                }
                case 21: {
                    ValidateUtils.isTrue((MqttPropertyConstant.AUTHENTICATION_METHOD_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.AUTHENTICATION_METHOD_BIT;
                    this.authenticationMethod = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 22: {
                    ValidateUtils.isTrue((MqttPropertyConstant.AUTHENTICATION_DATA_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.AUTHENTICATION_DATA_BIT;
                    this.authenticationData = MqttCodecUtil.decodeByteArray(buffer);
                    continue block29;
                }
                case 23: {
                    ValidateUtils.isTrue((MqttPropertyConstant.REQUEST_PROBLEM_INFORMATION_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.REQUEST_PROBLEM_INFORMATION_BIT;
                    this.requestProblemInformation = buffer.get();
                    ValidateUtils.isTrue(this.requestProblemInformation == 0 || this.requestProblemInformation == 1, "");
                    continue block29;
                }
                case 24: {
                    ValidateUtils.isTrue((MqttPropertyConstant.WILL_DELAY_INTERVAL_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.WILL_DELAY_INTERVAL_BIT;
                    this.willDelayInterval = buffer.getInt();
                    ValidateUtils.isTrue(this.willDelayInterval >= 0, "");
                    continue block29;
                }
                case 25: {
                    ValidateUtils.isTrue((MqttPropertyConstant.REQUEST_RESPONSE_INFORMATION_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.REQUEST_RESPONSE_INFORMATION_BIT;
                    this.requestResponseInformation = buffer.get();
                    ValidateUtils.isTrue(this.requestResponseInformation == 0 || this.requestResponseInformation == 1, "");
                    continue block29;
                }
                case 26: {
                    ValidateUtils.isTrue((MqttPropertyConstant.RESPONSE_INFORMATION_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.RESPONSE_INFORMATION_BIT;
                    this.responseInformation = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 28: {
                    ValidateUtils.isTrue((MqttPropertyConstant.SERVER_REFERENCE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.SERVER_REFERENCE_BIT;
                    this.serverReference = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 31: {
                    ValidateUtils.isTrue((MqttPropertyConstant.REASON_STRING_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.REASON_STRING_BIT;
                    this.reasonString = MqttCodecUtil.decodeUTF8(buffer);
                    continue block29;
                }
                case 33: {
                    ValidateUtils.isTrue((MqttPropertyConstant.RECEIVE_MAXIMUM_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.RECEIVE_MAXIMUM_BIT;
                    this.receiveMaximum = MqttCodecUtil.decodeMsbLsb(buffer);
                    continue block29;
                }
                case 34: {
                    ValidateUtils.isTrue((MqttPropertyConstant.TOPIC_ALIAS_MAXIMUM_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.TOPIC_ALIAS_MAXIMUM_BIT;
                    this.topicAliasMaximum = MqttCodecUtil.decodeMsbLsb(buffer);
                    ValidateUtils.isTrue(this.topicAliasMaximum >= 0, "");
                    continue block29;
                }
                case 35: {
                    ValidateUtils.isTrue((MqttPropertyConstant.TOPIC_ALIAS_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.TOPIC_ALIAS_BIT;
                    this.topicAlias = MqttCodecUtil.decodeMsbLsb(buffer);
                    continue block29;
                }
                case 36: {
                    ValidateUtils.isTrue((MqttPropertyConstant.MAXIMUM_QOS_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.MAXIMUM_QOS_BIT;
                    this.maximumQoS = buffer.get();
                    ValidateUtils.isTrue(this.maximumQoS == 0 || this.maximumQoS == 1, "");
                    continue block29;
                }
                case 37: {
                    ValidateUtils.isTrue((MqttPropertyConstant.RETAIN_AVAILABLE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.RETAIN_AVAILABLE_BIT;
                    this.retainAvailable = buffer.get();
                    ValidateUtils.isTrue(this.retainAvailable == 0 || this.retainAvailable == 1, "");
                    continue block29;
                }
                case 38: {
                    ValidateUtils.isTrue((MqttPropertyConstant.USER_PROPERTY_BIT & validBites) > 0, "");
                    String key = MqttCodecUtil.decodeUTF8(buffer);
                    String value = MqttCodecUtil.decodeUTF8(buffer);
                    this.userProperties.add(new UserProperty(key, value));
                    continue block29;
                }
                case 39: {
                    ValidateUtils.isTrue((MqttPropertyConstant.MAXIMUM_PACKET_SIZE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.MAXIMUM_PACKET_SIZE_BIT;
                    this.maximumPacketSize = buffer.getInt();
                    ValidateUtils.isTrue(this.maximumPacketSize > 0, "");
                    continue block29;
                }
                case 40: {
                    ValidateUtils.isTrue((MqttPropertyConstant.WILDCARD_SUBSCRIPTION_AVAILABLE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.WILDCARD_SUBSCRIPTION_AVAILABLE_BIT;
                    this.wildcardSubscriptionAvailable = buffer.get();
                    ValidateUtils.isTrue(this.wildcardSubscriptionAvailable == 0 || this.wildcardSubscriptionAvailable == 1, "");
                    continue block29;
                }
                case 41: {
                    ValidateUtils.isTrue((MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_AVAILABLE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_AVAILABLE_BIT;
                    this.subscriptionIdentifierAvailable = buffer.get();
                    ValidateUtils.isTrue(this.subscriptionIdentifierAvailable == 0 || this.subscriptionIdentifierAvailable == 1, "");
                    continue block29;
                }
                case 42: {
                    ValidateUtils.isTrue((MqttPropertyConstant.SHARED_SUBSCRIPTION_AVAILABLE_BIT & validBites) > 0, "");
                    validBites &= ~MqttPropertyConstant.SHARED_SUBSCRIPTION_AVAILABLE_BIT;
                    this.sharedSubscriptionAvailable = buffer.get();
                    ValidateUtils.isTrue(this.sharedSubscriptionAvailable == 0 || this.sharedSubscriptionAvailable == 1, "");
                }
            }
        }
    }

    public int preEncode(int validBites) {
        int length = 0;
        if (this.payloadFormatIndicator == 1 && (MqttPropertyConstant.PAYLOAD_FORMAT_INDICATOR_BIT & validBites) > 0) {
            length += 2;
        }
        if (this.messageExpiryInterval > 0 && (MqttPropertyConstant.MESSAGE_EXPIRY_INTERVAL_BIT & validBites) > 0) {
            length += 5;
        }
        if (this.contentType != null && (MqttPropertyConstant.CONTENT_TYPE_BIT & validBites) > 0) {
            this.contentTypeBytes = MqttCodecUtil.encodeUTF8(this.contentType);
            length += 1 + this.contentTypeBytes.length;
        }
        if (this.responseTopic != null && (MqttPropertyConstant.RESPONSE_TOPIC_BIT & validBites) > 0) {
            this.responseTopicBytes = MqttCodecUtil.encodeUTF8(this.responseTopic);
            length += 1 + this.responseTopicBytes.length;
        }
        if (this.correlationData != null && (MqttPropertyConstant.CORRELATION_DATA_BIT & validBites) > 0) {
            length += 1 + this.correlationData.length;
        }
        if (this.subscriptionIdentifier > 0 && (MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_BIT & validBites) > 0) {
            length += 1 + MqttCodecUtil.getVariableLengthInt(this.subscriptionIdentifier);
        }
        if (this.sessionExpiryInterval > 0 && (MqttPropertyConstant.SESSION_EXPIRY_INTERVAL_BIT & validBites) > 0) {
            length += 5;
        }
        if (this.assignedClientIdentifier != null && (MqttPropertyConstant.ASSIGNED_CLIENT_IDENTIFIER_BIT & validBites) > 0) {
            this.assignedClientIdentifierBytes = MqttCodecUtil.encodeUTF8(this.assignedClientIdentifier);
            length += 1 + this.assignedClientIdentifierBytes.length;
        }
        if (this.serverKeepAlive > 0 && (MqttPropertyConstant.SERVER_KEEP_ALIVE_BIT & validBites) > 0) {
            length += 3;
        }
        if (this.authenticationMethod != null && (MqttPropertyConstant.AUTHENTICATION_METHOD_BIT & validBites) > 0) {
            this.authenticationMethodBytes = MqttCodecUtil.encodeUTF8(this.authenticationMethod);
            length += 1 + this.authenticationMethodBytes.length;
        }
        if (this.authenticationData != null && (MqttPropertyConstant.AUTHENTICATION_DATA_BIT & validBites) > 0) {
            length += 1 + this.authenticationData.length;
        }
        if (this.requestProblemInformation == 0 && MqttPropertyConstant.REQUEST_PROBLEM_INFORMATION_BIT > 0) {
            length += 2;
        }
        if (this.willDelayInterval > 0 && (MqttPropertyConstant.WILL_DELAY_INTERVAL_BIT & validBites) > 0) {
            length += 5;
        }
        if (this.requestResponseInformation == 1 && (MqttPropertyConstant.REQUEST_RESPONSE_INFORMATION_BIT & validBites) > 0) {
            length += 2;
        }
        if (this.responseInformation != null && (MqttPropertyConstant.RESPONSE_INFORMATION_BIT & validBites) > 0) {
            this.responseInformationBytes = MqttCodecUtil.encodeUTF8(this.responseInformation);
            length += 1 + this.responseInformationBytes.length;
        }
        if (this.serverReference != null && (MqttPropertyConstant.SERVER_REFERENCE_BIT & validBites) > 0) {
            this.serverReferenceBytes = MqttCodecUtil.encodeUTF8(this.serverReference);
            length += 1 + this.serverReferenceBytes.length;
        }
        if (this.reasonString != null && (MqttPropertyConstant.REASON_STRING_BIT & validBites) > 0) {
            this.reasonStringBytes = MqttCodecUtil.encodeUTF8(this.reasonString);
            length += 1 + this.reasonStringBytes.length;
        }
        if (this.receiveMaximum > 0 && this.receiveMaximum < 65535 && (MqttPropertyConstant.RECEIVE_MAXIMUM_BIT & validBites) > 0) {
            length += 3;
        }
        if (this.topicAliasMaximum > 0 && (MqttPropertyConstant.TOPIC_ALIAS_MAXIMUM_BIT & validBites) > 0) {
            length += 3;
        }
        if (this.topicAlias > 0 && (MqttPropertyConstant.TOPIC_ALIAS_BIT & validBites) > 0) {
            length += 3;
        }
        if (this.maximumQoS != -1 && (MqttPropertyConstant.MAXIMUM_QOS_BIT & validBites) > 0) {
            length += 2;
        }
        if (this.retainAvailable == 0 && (MqttPropertyConstant.RETAIN_AVAILABLE_BIT & validBites) > 0) {
            length += 2;
        }
        if (this.userProperties.size() > 0 && (MqttPropertyConstant.USER_PROPERTY_BIT & validBites) > 0) {
            ++length;
            for (UserProperty userProperty : this.userProperties) {
                userProperty.decode();
                length += userProperty.getKeyBytes().length + userProperty.getValueBytes().length;
            }
        }
        if (this.maximumPacketSize > 0 && (MqttPropertyConstant.MAXIMUM_PACKET_SIZE_BIT & validBites) > 0) {
            length += 5;
        }
        if (this.wildcardSubscriptionAvailable == 0 && (MqttPropertyConstant.WILDCARD_SUBSCRIPTION_AVAILABLE_BIT & validBites) > 0) {
            length += 2;
        }
        if (this.subscriptionIdentifierAvailable == 0 && (MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_BIT & validBites) > 0) {
            length += 2;
        }
        if (this.sharedSubscriptionAvailable == 0 && (MqttPropertyConstant.SHARED_SUBSCRIPTION_AVAILABLE_BIT & validBites) > 0) {
            length += 2;
        }
        return length;
    }

    public void writeTo(MqttWriter writer, int validBites) throws IOException {
        if (this.payloadFormatIndicator == 1 && (MqttPropertyConstant.PAYLOAD_FORMAT_INDICATOR_BIT & validBites) > 0) {
            writer.writeByte((byte)1);
            writer.writeByte(this.payloadFormatIndicator);
        }
        if (this.messageExpiryInterval > 0 && (MqttPropertyConstant.MESSAGE_EXPIRY_INTERVAL_BIT & validBites) > 0) {
            writer.writeByte((byte)2);
            writer.writeInt(this.messageExpiryInterval);
        }
        if (this.contentType != null && (MqttPropertyConstant.CONTENT_TYPE_BIT & validBites) > 0) {
            writer.writeByte((byte)3);
            writer.write(this.contentTypeBytes);
        }
        if (this.responseTopic != null && (MqttPropertyConstant.RESPONSE_TOPIC_BIT & validBites) > 0) {
            writer.writeByte((byte)8);
            writer.write(this.responseTopicBytes);
        }
        if (this.correlationData != null && (MqttPropertyConstant.CORRELATION_DATA_BIT & validBites) > 0) {
            writer.writeByte((byte)9);
            writer.write(this.correlationData);
        }
        if (this.subscriptionIdentifier > 0 && (MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_BIT & validBites) > 0) {
            writer.writeByte((byte)11);
            MqttCodecUtil.writeVariableLengthInt(writer, this.subscriptionIdentifier);
        }
        if (this.sessionExpiryInterval > 0 && (MqttPropertyConstant.SESSION_EXPIRY_INTERVAL_BIT & validBites) > 0) {
            writer.writeByte((byte)17);
            writer.writeInt(this.sessionExpiryInterval);
        }
        if (this.assignedClientIdentifier != null && (MqttPropertyConstant.ASSIGNED_CLIENT_IDENTIFIER_BIT & validBites) > 0) {
            writer.writeByte((byte)18);
            writer.write(this.assignedClientIdentifierBytes);
        }
        if (this.serverKeepAlive > 0 && (MqttPropertyConstant.SERVER_KEEP_ALIVE_BIT & validBites) > 0) {
            writer.writeByte((byte)19);
            MqttCodecUtil.writeMsbLsb(writer, this.serverKeepAlive);
        }
        if (this.authenticationMethod != null && (MqttPropertyConstant.AUTHENTICATION_METHOD_BIT & validBites) > 0) {
            writer.writeByte((byte)21);
            writer.write(this.authenticationMethodBytes);
        }
        if (this.authenticationData != null && (MqttPropertyConstant.AUTHENTICATION_DATA_BIT & validBites) > 0) {
            writer.writeByte((byte)22);
            writer.write(this.authenticationData);
        }
        if (this.requestProblemInformation == 0 && MqttPropertyConstant.REQUEST_PROBLEM_INFORMATION_BIT > 0) {
            writer.writeByte((byte)23);
            writer.writeByte(this.requestProblemInformation);
        }
        if (this.willDelayInterval > 0 && (MqttPropertyConstant.WILL_DELAY_INTERVAL_BIT & validBites) > 0) {
            writer.writeByte((byte)24);
            writer.writeInt(this.willDelayInterval);
        }
        if (this.requestResponseInformation == 1 && (MqttPropertyConstant.REQUEST_RESPONSE_INFORMATION_BIT & validBites) > 0) {
            writer.writeByte((byte)25);
            writer.writeByte(this.requestResponseInformation);
        }
        if (this.responseInformation != null && (MqttPropertyConstant.RESPONSE_INFORMATION_BIT & validBites) > 0) {
            writer.writeByte((byte)26);
            writer.write(this.responseInformationBytes);
        }
        if (this.serverReference != null && (MqttPropertyConstant.SERVER_REFERENCE_BIT & validBites) > 0) {
            writer.writeByte((byte)28);
            writer.write(this.serverReferenceBytes);
        }
        if (this.reasonString != null && (MqttPropertyConstant.REASON_STRING_BIT & validBites) > 0) {
            writer.writeByte((byte)31);
            writer.write(this.reasonStringBytes);
        }
        if (this.receiveMaximum > 0 && this.receiveMaximum < 65535 && (MqttPropertyConstant.RECEIVE_MAXIMUM_BIT & validBites) > 0) {
            writer.writeByte((byte)33);
            MqttCodecUtil.writeMsbLsb(writer, this.receiveMaximum);
        }
        if (this.topicAliasMaximum > 0 && (MqttPropertyConstant.TOPIC_ALIAS_MAXIMUM_BIT & validBites) > 0) {
            writer.writeByte((byte)34);
            MqttCodecUtil.writeMsbLsb(writer, this.topicAliasMaximum);
        }
        if (this.topicAlias > 0 && (MqttPropertyConstant.TOPIC_ALIAS_BIT & validBites) > 0) {
            writer.writeByte((byte)35);
            MqttCodecUtil.writeMsbLsb(writer, this.topicAlias);
        }
        if (this.maximumQoS != -1 && (MqttPropertyConstant.MAXIMUM_QOS_BIT & validBites) > 0) {
            writer.writeByte((byte)36);
            writer.writeByte(this.maximumQoS);
        }
        if (this.retainAvailable == 0 && (MqttPropertyConstant.RETAIN_AVAILABLE_BIT & validBites) > 0) {
            writer.writeByte((byte)37);
            writer.writeByte(this.retainAvailable);
        }
        if (this.userProperties.size() > 0 && (MqttPropertyConstant.USER_PROPERTY_BIT & validBites) > 0) {
            writer.writeByte((byte)38);
            for (UserProperty userProperty : this.userProperties) {
                writer.write(userProperty.getKeyBytes());
                writer.write(userProperty.getValueBytes());
            }
        }
        if (this.maximumPacketSize > 0 && (MqttPropertyConstant.MAXIMUM_PACKET_SIZE_BIT & validBites) > 0) {
            writer.writeByte((byte)39);
            writer.writeInt(this.maximumPacketSize);
        }
        if (this.wildcardSubscriptionAvailable == 0 && (MqttPropertyConstant.WILDCARD_SUBSCRIPTION_AVAILABLE_BIT & validBites) > 0) {
            writer.writeByte((byte)40);
            writer.writeByte(this.wildcardSubscriptionAvailable);
        }
        if (this.subscriptionIdentifierAvailable == 0 && (MqttPropertyConstant.SUBSCRIPTION_IDENTIFIER_AVAILABLE_BIT & validBites) > 0) {
            writer.writeByte((byte)41);
            writer.writeByte(this.maximumQoS);
        }
        if (this.sharedSubscriptionAvailable == 0 && (MqttPropertyConstant.SHARED_SUBSCRIPTION_AVAILABLE_BIT & validBites) > 0) {
            writer.writeByte((byte)42);
            writer.writeByte(this.sharedSubscriptionAvailable);
        }
    }

    public String getAuthenticationMethod() {
        return this.authenticationMethod;
    }

    public int getSessionExpiryInterval() {
        return this.sessionExpiryInterval;
    }

    public int getSubscriptionIdentifier() {
        return this.subscriptionIdentifier;
    }

    public int getWillDelayInterval() {
        return this.willDelayInterval;
    }

    public byte getPayloadFormatIndicator() {
        return this.payloadFormatIndicator;
    }

    public int getMessageExpiryInterval() {
        return this.messageExpiryInterval;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getResponseTopic() {
        return this.responseTopic;
    }

    public byte[] getCorrelationData() {
        return this.correlationData;
    }

    public String getAssignedClientIdentifier() {
        return this.assignedClientIdentifier;
    }

    public int getServerKeepAlive() {
        return this.serverKeepAlive;
    }

    public List<UserProperty> getUserProperties() {
        return this.userProperties;
    }

    public byte getRequestProblemInformation() {
        return this.requestProblemInformation;
    }

    public byte[] getAuthenticationData() {
        return this.authenticationData;
    }

    public byte getRequestResponseInformation() {
        return this.requestResponseInformation;
    }

    public String getResponseInformation() {
        return this.responseInformation;
    }

    public String getServerReference() {
        return this.serverReference;
    }

    public String getReasonString() {
        return this.reasonString;
    }

    public int getTopicAliasMaximum() {
        return this.topicAliasMaximum;
    }

    public int getReceiveMaximum() {
        return this.receiveMaximum;
    }

    public int getTopicAlias() {
        return this.topicAlias;
    }

    public int getMaximumQoS() {
        return this.maximumQoS;
    }

    public byte getRetainAvailable() {
        return this.retainAvailable;
    }

    public Integer getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public byte getWildcardSubscriptionAvailable() {
        return this.wildcardSubscriptionAvailable;
    }

    public byte getSubscriptionIdentifierAvailable() {
        return this.subscriptionIdentifierAvailable;
    }

    public byte getSharedSubscriptionAvailable() {
        return this.sharedSubscriptionAvailable;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    public void setSessionExpiryInterval(int sessionExpiryInterval) {
        this.sessionExpiryInterval = sessionExpiryInterval;
    }

    public void setSubscriptionIdentifier(int subscriptionIdentifier) {
        this.subscriptionIdentifier = subscriptionIdentifier;
    }

    public void setWillDelayInterval(int willDelayInterval) {
        this.willDelayInterval = willDelayInterval;
    }

    public void setPayloadFormatIndicator(byte payloadFormatIndicator) {
        this.payloadFormatIndicator = payloadFormatIndicator;
    }

    public void setMessageExpiryInterval(int messageExpiryInterval) {
        this.messageExpiryInterval = messageExpiryInterval;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setResponseTopic(String responseTopic) {
        this.responseTopic = responseTopic;
    }

    public void setCorrelationData(byte[] correlationData) {
        this.correlationData = correlationData;
    }

    public void setAssignedClientIdentifier(String assignedClientIdentifier) {
        this.assignedClientIdentifier = assignedClientIdentifier;
    }

    public void setServerKeepAlive(int serverKeepAlive) {
        this.serverKeepAlive = serverKeepAlive;
    }

    public void setRequestProblemInformation(byte requestProblemInformation) {
        this.requestProblemInformation = requestProblemInformation;
    }

    public void setAuthenticationData(byte[] authenticationData) {
        this.authenticationData = authenticationData;
    }

    public void setRequestResponseInformation(byte requestResponseInformation) {
        this.requestResponseInformation = requestResponseInformation;
    }

    public void setResponseInformation(String responseInformation) {
        this.responseInformation = responseInformation;
    }

    public void setServerReference(String serverReference) {
        this.serverReference = serverReference;
    }

    public void setReasonString(String reasonString) {
        this.reasonString = reasonString;
    }

    public void setTopicAliasMaximum(int topicAliasMaximum) {
        this.topicAliasMaximum = topicAliasMaximum;
    }

    public void setReceiveMaximum(int receiveMaximum) {
        this.receiveMaximum = receiveMaximum;
    }

    public void setTopicAlias(int topicAlias) {
        this.topicAlias = topicAlias;
    }

    public void setMaximumQoS(byte maximumQoS) {
        this.maximumQoS = maximumQoS;
    }

    public void setRetainAvailable(byte retainAvailable) {
        this.retainAvailable = retainAvailable;
    }

    public void setMaximumPacketSize(Integer maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }

    public void setWildcardSubscriptionAvailable(byte wildcardSubscriptionAvailable) {
        this.wildcardSubscriptionAvailable = wildcardSubscriptionAvailable;
    }

    public void setSubscriptionIdentifierAvailable(byte subscriptionIdentifierAvailable) {
        this.subscriptionIdentifierAvailable = subscriptionIdentifierAvailable;
    }

    public void setSharedSubscriptionAvailable(byte sharedSubscriptionAvailable) {
        this.sharedSubscriptionAvailable = sharedSubscriptionAvailable;
    }
}

