/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.variable;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttVariableHeader;
import tech.smartboot.mqtt.common.message.payload.WillMessage;
import tech.smartboot.mqtt.common.message.variable.properties.ConnectProperties;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public final class MqttConnectVariableHeader
extends MqttVariableHeader<ConnectProperties> {
    private final String protocolName;
    private final byte protocolLevel;
    private final boolean hasUserName;
    private final boolean hasPassword;
    private final boolean isWillRetain;
    private final int willQos;
    private final boolean isWillFlag;
    private final boolean isCleanSession;
    private final int reserved;
    private final int keepAliveTimeSeconds;

    public MqttConnectVariableHeader(String name, byte protocolLevel, int connectFlag, int keepAliveTimeSeconds, ConnectProperties properties) {
        super(properties);
        this.protocolName = name;
        this.protocolLevel = protocolLevel;
        this.hasUserName = (connectFlag & 0x80) == 128;
        this.hasPassword = (connectFlag & 0x40) == 64;
        this.isWillRetain = (connectFlag & 0x20) == 32;
        this.willQos = (connectFlag & 0x18) >> 3;
        this.isWillFlag = (connectFlag & 4) == 4;
        this.isCleanSession = (connectFlag & 2) == 2;
        this.reserved = connectFlag & 1;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    public MqttConnectVariableHeader(MqttVersion mqttVersion, boolean hasUserName, boolean hasPassword, WillMessage willMessage, boolean isCleanSession, int keepAliveTimeSeconds, ConnectProperties properties) {
        super(properties);
        this.protocolName = mqttVersion.protocolName();
        this.protocolLevel = mqttVersion.protocolLevel();
        this.hasUserName = hasUserName;
        this.hasPassword = hasPassword;
        this.isWillFlag = willMessage != null;
        this.isWillRetain = this.isWillFlag && willMessage.isRetained();
        this.willQos = this.isWillFlag ? willMessage.getWillQos().value() : 0;
        this.isCleanSession = isCleanSession;
        this.reserved = 0;
        this.keepAliveTimeSeconds = keepAliveTimeSeconds;
    }

    public String protocolName() {
        return this.protocolName;
    }

    public byte getProtocolLevel() {
        return this.protocolLevel;
    }

    public boolean hasUserName() {
        return this.hasUserName;
    }

    public boolean hasPassword() {
        return this.hasPassword;
    }

    public boolean isWillRetain() {
        return this.isWillRetain;
    }

    public int willQos() {
        return this.willQos;
    }

    public boolean isWillFlag() {
        return this.isWillFlag;
    }

    public boolean isCleanSession() {
        return this.isCleanSession;
    }

    public int keepAliveTimeSeconds() {
        return this.keepAliveTimeSeconds;
    }

    public int getReserved() {
        return this.reserved;
    }

    @Override
    protected int preEncode0() {
        return 10;
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        byte[] nameBytes = this.protocolName.getBytes(StandardCharsets.UTF_8);
        ValidateUtils.isTrue(nameBytes.length == 4, "invalid protocol name");
        mqttWriter.writeShort((short)nameBytes.length);
        mqttWriter.write(nameBytes);
        mqttWriter.writeByte(this.protocolLevel);
        byte connectFlag = 0;
        if (this.hasUserName) {
            connectFlag = -128;
        }
        if (this.hasPassword) {
            connectFlag = (byte)(connectFlag | 0x40);
        }
        if (this.isWillFlag) {
            connectFlag = (byte)(connectFlag | 4);
            connectFlag = (byte)(connectFlag | this.willQos << 3);
            if (this.isWillRetain) {
                connectFlag = (byte)(connectFlag | 0x20);
            }
        }
        if (this.isCleanSession) {
            connectFlag = (byte)(connectFlag | 2);
        }
        mqttWriter.writeByte(connectFlag);
        mqttWriter.writeShort((short)this.keepAliveTimeSeconds);
        if (this.properties != null) {
            ((ConnectProperties)this.properties).writeTo(mqttWriter);
        }
    }
}

