/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message.variable;

import java.io.IOException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.enums.MqttConnectReturnCode;
import tech.smartboot.mqtt.common.message.MqttVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ConnectAckProperties;

public class MqttConnAckVariableHeader
extends MqttVariableHeader<ConnectAckProperties> {
    private final MqttConnectReturnCode connectReturnCode;
    private final boolean sessionPresent;

    public MqttConnAckVariableHeader(MqttConnectReturnCode connectReturnCode, boolean sessionPresent, ConnectAckProperties properties) {
        super(properties);
        this.connectReturnCode = connectReturnCode;
        this.sessionPresent = sessionPresent;
    }

    public MqttConnectReturnCode connectReturnCode() {
        return this.connectReturnCode;
    }

    public boolean isSessionPresent() {
        return this.sessionPresent;
    }

    @Override
    protected int preEncode0() {
        return 2;
    }

    @Override
    protected void writeTo(MqttWriter mqttWriter) throws IOException {
        mqttWriter.writeByte((byte)(this.sessionPresent ? 1 : 0));
        mqttWriter.writeByte(this.connectReturnCode.getCode());
        if (this.properties != null) {
            ((ConnectAckProperties)this.properties).writeTo(mqttWriter);
        }
    }
}

