/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttCodecUtil;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttPacketIdentifierMessage;
import tech.smartboot.mqtt.common.message.MqttTopicSubscription;
import tech.smartboot.mqtt.common.message.payload.MqttSubscribePayload;
import tech.smartboot.mqtt.common.message.variable.MqttSubscribeVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.SubscribeProperties;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public class MqttSubscribeMessage
extends MqttPacketIdentifierMessage<MqttSubscribeVariableHeader> {
    private MqttSubscribePayload payload;

    public MqttSubscribeMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    public MqttSubscribeMessage(MqttFixedHeader mqttFixedHeader, MqttSubscribeVariableHeader variableHeader, MqttSubscribePayload payload) {
        super(mqttFixedHeader);
        this.setVariableHeader(variableHeader);
        this.payload = payload;
    }

    @Override
    public void decodeVariableHeader0(ByteBuffer buffer) {
        MqttSubscribeVariableHeader header;
        int packetId = this.decodeMessageId(buffer);
        if (this.version == MqttVersion.MQTT_5) {
            SubscribeProperties properties = new SubscribeProperties();
            properties.decode(buffer);
            header = new MqttSubscribeVariableHeader(packetId, properties);
        } else {
            header = new MqttSubscribeVariableHeader(packetId, null);
        }
        this.setVariableHeader(header);
    }

    @Override
    public void decodePlayLoad(ByteBuffer buffer) {
        ArrayList<MqttTopicSubscription> subscribeTopics = new ArrayList<MqttTopicSubscription>();
        int payloadLength = this.getRemainingLength() - this.getVariableHeaderLength();
        ValidateUtils.isTrue(buffer.remaining() >= payloadLength, "\u6570\u636e\u4e0d\u8db3");
        int limit = buffer.limit();
        buffer.limit(buffer.position() + payloadLength);
        while (buffer.hasRemaining()) {
            String decodedTopicName = MqttCodecUtil.decodeUTF8(buffer);
            int qos = buffer.get() & 3;
            MqttTopicSubscription subscription = new MqttTopicSubscription();
            subscription.setTopicFilter(decodedTopicName);
            subscription.setQualityOfService(MqttQoS.valueOf(qos));
            subscribeTopics.add(subscription);
        }
        buffer.limit(limit);
        this.payload = new MqttSubscribePayload();
        this.payload.setTopicSubscriptions(subscribeTopics);
    }

    @Override
    public MqttSubscribePayload getPayload() {
        return this.payload;
    }
}

