/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttFixedHeader;
import tech.smartboot.mqtt.common.message.MqttPacketIdentifierMessage;
import tech.smartboot.mqtt.common.message.payload.MqttSubAckPayload;
import tech.smartboot.mqtt.common.message.variable.MqttReasonVariableHeader;
import tech.smartboot.mqtt.common.message.variable.properties.ReasonProperties;

public class MqttSubAckMessage
extends MqttPacketIdentifierMessage<MqttReasonVariableHeader> {
    private MqttSubAckPayload payload;

    public MqttSubAckMessage(MqttFixedHeader mqttFixedHeader) {
        super(mqttFixedHeader);
    }

    public MqttSubAckMessage(MqttReasonVariableHeader variableHeader) {
        super(MqttFixedHeader.SUB_ACK_HEADER, variableHeader);
    }

    @Override
    protected void decodeVariableHeader0(ByteBuffer buffer) {
        MqttReasonVariableHeader header;
        int packetId = this.decodeMessageId(buffer);
        if (this.version == MqttVersion.MQTT_5) {
            ReasonProperties properties = new ReasonProperties();
            properties.decode(buffer);
            header = new MqttReasonVariableHeader(packetId, properties);
        } else {
            header = new MqttReasonVariableHeader(packetId, null);
        }
        this.setVariableHeader(header);
    }

    @Override
    public void decodePlayLoad(ByteBuffer buffer) {
        int payloadLength = this.getRemainingLength() - this.getVariableHeaderLength();
        ArrayList<Integer> grantedQos = new ArrayList<Integer>();
        int limit = buffer.limit();
        buffer.limit(buffer.position() + payloadLength);
        while (buffer.hasRemaining()) {
            int qos = buffer.get() & 3;
            grantedQos.add(qos);
        }
        buffer.limit(limit);
        this.payload = new MqttSubAckPayload(grantedQos);
    }

    @Override
    public MqttSubAckPayload getPayload() {
        return this.payload;
    }

    public void setPayload(MqttSubAckPayload payload) {
        this.payload = payload;
    }
}

