/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.message;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.smartboot.socket.DecoderException;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.exception.MqttException;

public final class MqttCodecUtil {
    private MqttCodecUtil() {
    }

    public static int decodeVariableByteInteger(ByteBuffer buffer) {
        byte encodedByte;
        int multiplier = 1;
        int value = 0;
        do {
            encodedByte = buffer.get();
            value += (encodedByte & 0x7F) * multiplier;
            if (multiplier > 0x200000) {
                throw new DecoderException("decode Variable Byte Integer error");
            }
            multiplier *= 128;
        } while ((encodedByte & 0x80) != 0);
        return value;
    }

    public static void writeVariableLengthInt(MqttWriter buf, int num) throws IOException {
        if (num <= 127) {
            buf.writeByte((byte)num);
        } else if (num <= 16383) {
            buf.writeByte((byte)(num | 0x80));
            buf.writeByte((byte)(num >>> 7));
        } else if (num <= 0xFFFFFFF) {
            do {
                int digit = num & 0x7F;
                if ((num >>>= 7) != 0) {
                    digit |= 0x80;
                }
                buf.writeByte((byte)digit);
            } while (num != 0);
        } else {
            throw new IOException("payload too large");
        }
    }

    public static String decodeUTF8(ByteBuffer buffer) {
        int size = MqttCodecUtil.decodeMsbLsb(buffer);
        if (size < 0 || size > 65535) {
            throw new DecoderException("invalid string length " + size);
        }
        byte[] bytes = new byte[size];
        buffer.get(bytes);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] encodeUTF8(String str) {
        byte[] bytes = str.getBytes(StandardCharsets.UTF_8);
        if (bytes.length > 65535) {
            throw new MqttException("encoded string too long: " + bytes.length + " bytes", () -> {});
        }
        byte[] bytearr = new byte[bytes.length + 2];
        bytearr[0] = (byte)(bytes.length >>> 8 & 0xFF);
        bytearr[1] = (byte)(bytes.length & 0xFF);
        System.arraycopy(bytes, 0, bytearr, 2, bytes.length);
        return bytearr;
    }

    public static int decodeMsbLsb(ByteBuffer buffer) {
        return buffer.getShort() & 0xFFFF;
    }

    public static void writeMsbLsb(MqttWriter writer, int v) throws IOException {
        writer.writeShort((short)v);
    }

    public static byte[] decodeByteArray(ByteBuffer buffer) {
        int decodedSize = MqttCodecUtil.decodeMsbLsb(buffer);
        byte[] bytes = new byte[decodedSize];
        buffer.get(bytes);
        return bytes;
    }

    public static int getVariableLengthInt(int num) {
        int count = 0;
        do {
            ++count;
        } while ((num >>>= 7) > 0);
        return count;
    }
}

