/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common.enums;

public enum MqttMessageType {
    Reserved(0, "\u4fdd\u7559"),
    CONNECT(1, "\u5ba2\u6237\u7aef\u8bf7\u6c42\u8fde\u63a5\u670d\u52a1\u7aef"),
    CONNACK(2, "\u8fde\u63a5\u62a5\u6587\u786e\u8ba4"),
    PUBLISH(3, "\u53d1\u5e03\u6d88\u606f"),
    PUBACK(4, "QoS1 \u6d88\u606f\u53d1\u5e03\u6536\u5230\u786e\u8ba4"),
    PUBREC(5, "\u53d1\u5e03\u6536\u5230\uff08\u4fdd\u8bc1\u4ea4\u4ed8\u7b2c\u4e00\u6b65\uff09"),
    PUBREL(6, "\u53d1\u5e03\u91ca\u653e\uff08\u4fdd\u8bc1\u4ea4\u4ed8\u7b2c\u4e8c\u6b65\uff09"),
    PUBCOMP(7, "QoS2 \u6d88\u606f\u53d1\u5e03\u5b8c\u6210\uff08\u4fdd\u8bc1\u4ea4\u4e92\u7b2c\u4e09\u6b65\uff09"),
    SUBSCRIBE(8, "\u5ba2\u6237\u7aef\u8ba2\u9605\u8bf7\u6c42"),
    SUBACK(9, "\u8ba2\u9605\u8bf7\u6c42\u62a5\u6587\u786e\u8ba4"),
    UNSUBSCRIBE(10, "\u5ba2\u6237\u7aef\u53d6\u6d88\u8ba2\u9605\u8bf7\u6c42"),
    UNSUBACK(11, "\u53d6\u6d88\u8ba2\u9605\u62a5\u6587\u786e\u8ba4"),
    PINGREQ(12, "\u5fc3\u8df3\u8bf7\u6c42"),
    PINGRESP(13, "\u5fc3\u8df3\u54cd\u5e94"),
    DISCONNECT(14, "\u5ba2\u6237\u7aef\u65ad\u5f00\u8fde\u63a5"),
    Reserved2(15, "\u4fdd\u7559");

    private final int value;
    private String desc;
    private static final MqttMessageType[] values;

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    private MqttMessageType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static MqttMessageType valueOf(int type) {
        if (type < 0 || type >= values.length) {
            throw new IllegalArgumentException("unknown message type: " + type);
        }
        MqttMessageType t = values[type];
        if (t.value != type) {
            throw new IllegalArgumentException("unknown message type: " + type);
        }
        return t;
    }

    public int value() {
        return this.value;
    }

    static {
        values = MqttMessageType.values();
    }
}

