/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import tech.smartboot.mqtt.common.util.ValidateUtils;

public class TopicToken {
    private final String node;
    private final String topicFilter;
    private final TopicToken nextNode;

    public TopicToken(String node) {
        this(node, 0);
    }

    TopicToken(String node, int offset) {
        int index = node.indexOf(47, offset);
        if (index == -1) {
            this.node = node.substring(offset);
            ValidateUtils.isTrue(this.node.indexOf(35) == -1 || this.node.length() == 1, "invalid topic filter");
            ValidateUtils.isTrue(this.node.indexOf(43) == -1 || this.node.length() == 1, "invalid topic filter");
            this.nextNode = null;
        } else {
            this.node = node.substring(offset, index);
            ValidateUtils.isTrue(this.node.indexOf(35) == -1, "invalid topic filter");
            ValidateUtils.isTrue(this.node.indexOf(43) == -1 || this.node.length() == 1, "invalid topic filter");
            this.nextNode = new TopicToken(node, index + 1);
        }
        this.topicFilter = offset == 0 ? node : null;
    }

    public String getNode() {
        return this.node;
    }

    public String getTopicFilter() {
        return this.topicFilter;
    }

    public TopicToken getNextNode() {
        return this.nextNode;
    }

    public boolean isWildcards() {
        if (this.node.equals("+") || this.node.equals("#")) {
            return true;
        }
        return this.nextNode != null && this.nextNode.isWildcards();
    }

    public boolean isShared() {
        return this.node.equals("$share");
    }
}

