/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import java.nio.ByteBuffer;
import org.smartboot.socket.Protocol;
import org.smartboot.socket.transport.AioSession;
import tech.smartboot.mqtt.common.AbstractSession;
import tech.smartboot.mqtt.common.Decoder;
import tech.smartboot.mqtt.common.MqttHeaderDecoder;
import tech.smartboot.mqtt.common.message.MqttMessage;

public class MqttProtocol
implements Protocol<MqttMessage> {
    static final Decoder FINISH_DECODER = (byteBuffer, session) -> null;
    private final MqttHeaderDecoder mqttHeaderDecoder;

    public MqttProtocol(int maxBytesInMessage) {
        this.mqttHeaderDecoder = new MqttHeaderDecoder(maxBytesInMessage);
    }

    public MqttMessage decode(ByteBuffer buffer, AioSession session) {
        AbstractSession mqttSession = (AbstractSession)session.getAttachment();
        Decoder decodeChain = mqttSession.decoder;
        if (decodeChain == null) {
            decodeChain = this.mqttHeaderDecoder;
        }
        if ((decodeChain = decodeChain.decode(buffer, mqttSession)) == FINISH_DECODER) {
            MqttMessage mqttMessage = mqttSession.mqttMessage;
            mqttSession.decoder = this.mqttHeaderDecoder;
            mqttSession.mqttMessage = null;
            return mqttMessage;
        }
        mqttSession.decoder = decodeChain;
        return null;
    }
}

