/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import java.util.concurrent.CompletableFuture;
import tech.smartboot.mqtt.common.enums.MqttMessageType;
import tech.smartboot.mqtt.common.enums.MqttQoS;
import tech.smartboot.mqtt.common.message.MqttPacketIdentifierMessage;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.message.MqttSubscribeMessage;
import tech.smartboot.mqtt.common.message.MqttUnsubscribeMessage;
import tech.smartboot.mqtt.common.message.variable.MqttPacketIdVariableHeader;
import tech.smartboot.mqtt.common.util.MqttUtil;

public class InflightMessage {
    private final MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader> originalMessage;
    private MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader> responseMessage;
    private final CompletableFuture<MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader>> future = new CompletableFuture();
    private final int assignedPacketId;
    private MqttMessageType expectMessageType;
    private boolean commit;
    private int retryCount;
    private long latestTime;

    public InflightMessage(int packetId, MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader> originalMessage) {
        this.assignedPacketId = packetId;
        this.originalMessage = originalMessage;
        if (originalMessage instanceof MqttSubscribeMessage) {
            this.expectMessageType = MqttMessageType.SUBACK;
        } else if (originalMessage instanceof MqttUnsubscribeMessage) {
            this.expectMessageType = MqttMessageType.UNSUBACK;
        } else if (originalMessage instanceof MqttPublishMessage) {
            if (originalMessage.getFixedHeader().getQosLevel() == MqttQoS.AT_LEAST_ONCE) {
                this.expectMessageType = MqttMessageType.PUBACK;
            } else if (originalMessage.getFixedHeader().getQosLevel() == MqttQoS.EXACTLY_ONCE) {
                this.expectMessageType = MqttMessageType.PUBREC;
            }
        } else {
            throw new UnsupportedOperationException();
        }
        this.latestTime = MqttUtil.currentTimeMillis();
    }

    public MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader> getOriginalMessage() {
        return this.originalMessage;
    }

    public MqttMessageType getExpectMessageType() {
        return this.expectMessageType;
    }

    public void setExpectMessageType(MqttMessageType expectMessageType) {
        this.expectMessageType = expectMessageType;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public long getLatestTime() {
        return this.latestTime;
    }

    public void setLatestTime(long latestTime) {
        this.latestTime = latestTime;
    }

    public int getAssignedPacketId() {
        return this.assignedPacketId;
    }

    public MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader> getResponseMessage() {
        return this.responseMessage;
    }

    public void setResponseMessage(MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader> responseMessage) {
        this.responseMessage = responseMessage;
    }

    public CompletableFuture<MqttPacketIdentifierMessage<? extends MqttPacketIdVariableHeader>> getFuture() {
        return this.future;
    }
}

