/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import java.io.IOException;
import org.smartboot.socket.transport.WriteBuffer;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public class DefaultMqttWriter
implements MqttWriter {
    private final WriteBuffer writeBuffer;
    private int size;

    public DefaultMqttWriter(WriteBuffer writeBuffer) {
        this.writeBuffer = writeBuffer;
    }

    @Override
    public void reset() {
        this.size = 0;
    }

    @Override
    public void writeByte(byte b) {
        ++this.size;
        this.writeBuffer.writeByte(b);
    }

    @Override
    public void writeShort(short data) throws IOException {
        ValidateUtils.isTrue(this.size != 0, "error: writeShort can't write data, because writer is empty");
        this.size += 2;
        this.writeBuffer.writeShort(data);
    }

    @Override
    public void writeInt(int data) throws IOException {
        ValidateUtils.isTrue(this.size != 0, "error: writeShort can't write data, because writer is empty");
        this.size += 4;
        this.writeBuffer.writeInt(data);
    }

    @Override
    public void write(byte[] data) throws IOException {
        ValidateUtils.isTrue(this.size != 0, "error: writeShort can't write data, because writer is empty");
        this.size += data.length;
        this.writeBuffer.write(data);
    }

    @Override
    public void flush() {
        this.writeBuffer.flush();
    }

    @Override
    public int writeSize() {
        return this.size;
    }
}

