/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.mqtt.common;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Hashtable;
import org.smartboot.socket.transport.AioSession;
import tech.smartboot.mqtt.common.Decoder;
import tech.smartboot.mqtt.common.InflightQueue;
import tech.smartboot.mqtt.common.MqttWriter;
import tech.smartboot.mqtt.common.enums.MqttVersion;
import tech.smartboot.mqtt.common.message.MqttMessage;
import tech.smartboot.mqtt.common.message.MqttPubRecMessage;
import tech.smartboot.mqtt.common.message.MqttPublishMessage;
import tech.smartboot.mqtt.common.message.variable.MqttPubQosVariableHeader;
import tech.smartboot.mqtt.common.util.MqttUtil;
import tech.smartboot.mqtt.common.util.ValidateUtils;

public abstract class AbstractSession {
    protected String clientId;
    protected AioSession session;
    protected long latestSendMessageTime;
    protected boolean disconnect = false;
    protected MqttWriter mqttWriter;
    private MqttVersion mqttVersion;
    protected InflightQueue inflightQueue;
    private final Hashtable<Integer, MqttPublishMessage> ackMessageCacheMap = new Hashtable();
    Runnable retryRunnable;
    Decoder decoder;
    MqttMessage mqttMessage;
    ByteBuffer disposableBuffer;

    public final void write(MqttPubRecMessage mqttMessage, MqttPublishMessage publishMessage) {
        this.ackMessageCacheMap.put(((MqttPubQosVariableHeader)mqttMessage.getVariableHeader()).getPacketId(), publishMessage);
        this.write((MqttMessage)mqttMessage, false);
    }

    public final void notifyPubComp(int packetId) {
        MqttPublishMessage consumer = this.ackMessageCacheMap.remove(packetId);
        if (consumer != null) {
            this.accepted(consumer);
        }
    }

    protected abstract void accepted(MqttPublishMessage var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(MqttMessage mqttMessage, boolean autoFlush) {
        ValidateUtils.isTrue(!this.session.isInvalid(), "\u5df2\u65ad\u5f00\u8fde\u63a5,\u65e0\u6cd5\u53d1\u9001\u6d88\u606f");
        try {
            mqttMessage.setVersion(this.mqttVersion);
            MqttWriter mqttWriter = this.mqttWriter;
            synchronized (mqttWriter) {
                mqttMessage.write(this.mqttWriter);
            }
            if (autoFlush) {
                this.mqttWriter.flush();
            }
            this.latestSendMessageTime = MqttUtil.currentTimeMillis();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final void write(MqttMessage mqttMessage) {
        this.write(mqttMessage, true);
    }

    public final void flush() {
        if (!this.disconnect) {
            this.mqttWriter.flush();
        }
    }

    public final String getClientId() {
        return this.clientId;
    }

    public InetSocketAddress getRemoteAddress() throws IOException {
        return this.session.getRemoteAddress();
    }

    public abstract void disconnect();

    public final boolean isDisconnect() {
        return this.disconnect;
    }

    public final MqttVersion getMqttVersion() {
        return this.mqttVersion;
    }

    public final void setMqttVersion(MqttVersion mqttVersion) {
        this.mqttVersion = mqttVersion;
    }

    public final void setInflightQueue(InflightQueue inflightQueue) {
        this.inflightQueue = inflightQueue;
    }

    public final InflightQueue getInflightQueue() {
        return this.inflightQueue;
    }
}

