/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.license.client;

import java.util.concurrent.Semaphore;

public class Limit {
    private final Semaphore semaphore;
    private final int limit;

    public Limit(int n) {
        this.limit = n;
        this.semaphore = n > 0 ? new Semaphore(n) : null;
    }

    public boolean tryAcquire() {
        return this.semaphore == null || this.semaphore.tryAcquire();
    }

    public void release() {
        if (this.semaphore != null) {
            this.semaphore.release();
        }
    }

    public int available() {
        return this.semaphore != null ? this.semaphore.availablePermits() : 0;
    }

    public int limit() {
        return this.limit;
    }
}

