/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.license.client;

import java.io.Serializable;
import tech.smartboot.license.client.Limit;

public final class LicenseEntity
implements Serializable {
    public static final byte[] MAGIC_NUM = "smart-license".getBytes();
    private final byte[] publicKeys;
    private final long applyTime = System.currentTimeMillis();
    private final long expireTime;
    private String applicant;
    private String contact;
    private int trialDuration;
    private Limit limit = new Limit(0);
    private transient byte[] data;
    private boolean editable;

    public LicenseEntity(long l, byte[] byArray) {
        this.expireTime = l;
        this.publicKeys = byArray;
        this.editable = true;
    }

    void lock() {
        this.editable = false;
    }

    void checkState() {
        if (!this.editable) {
            throw new IllegalStateException("The license entity has been locked.");
        }
    }

    public long getExpireTime() {
        return this.expireTime;
    }

    public byte[] getPublicKeys() {
        return this.publicKeys;
    }

    public long getApplyTime() {
        return this.applyTime;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] byArray) {
        this.checkState();
        this.data = byArray;
    }

    public String getApplicant() {
        return this.applicant;
    }

    public void setApplicant(String string) {
        this.checkState();
        this.applicant = string;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String string) {
        this.checkState();
        this.contact = string;
    }

    public int getTrialDuration() {
        return this.trialDuration;
    }

    public void setTrialDuration(int n) {
        this.checkState();
        this.trialDuration = n;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(int n) {
        this.checkState();
        if (n > 0) {
            this.limit = new Limit(n);
        }
    }
}

