package tech.smartboot.license.client;

import java.util.concurrent.Semaphore;

/**
 * @author 三刀
 * @version v1.0 5/8/25
 */
public class Limit {
    private final Semaphore semaphore;
    private final int limit;

    public Limit(int limit) {
        this.limit = limit;
        if (limit > 0) {
            this.semaphore = new Semaphore(limit);
        } else {
            this.semaphore = null;
        }
    }

    public boolean tryAcquire() {
        return semaphore == null || semaphore.tryAcquire();
    }

    public void release() {
        if (semaphore != null) {
            semaphore.release();
        }
    }

    public int available() {
        return semaphore != null ? semaphore.availablePermits() : 0;
    }

    public int limit() {
        return limit;
    }
}
