/*
 * Copyright (c) 2020-2020, org.smartboot. All rights reserved.
 * project name: smart-license
 * file name: LicenseProtocol.java
 * Date: 2020-03-26
 * Author: sandao (zhengjunweimail@163.com)
 */

package tech.smartboot.license.client;

import java.io.Serializable;

/**
 * @author 三刀
 * @version V1.0 , 2020/3/26
 */
public final class LicenseEntity implements Serializable {

    /**
     * 魔数
     */
    public static final byte[] MAGIC_NUM = "smart-license".getBytes();
    /**
     * 公钥
     */
    private final byte[] publicKeys;
    /**
     * 申请时间
     */
    private final long applyTime = System.currentTimeMillis();

    /**
     * 过期时间
     */
    private final long expireTime;

    /**
     * 申请方
     */
    private String applicant;

    /**
     * 联系方式
     */
    private String contact;

    /**
     * 试用时长
     */
    private int trialDuration;

    /**
     * 资源额度
     */
    private Limit limit = new Limit(0);

    /**
     * 原文
     */
    private transient byte[] data;

    private boolean editable;

    public LicenseEntity(long expireTime, byte[] publicKeys) {
        this.expireTime = expireTime;
        this.publicKeys = publicKeys;
        this.editable = true;
    }

    void lock() {
        editable = false;
    }

    void checkState() {
        if (!editable) {
            throw new IllegalStateException("The license entity has been locked.");
        }
    }

    public long getExpireTime() {
        return expireTime;
    }

    public byte[] getPublicKeys() {
        return publicKeys;
    }

    public long getApplyTime() {
        return applyTime;
    }

    public byte[] getData() {
        return data;
    }

    public void setData(byte[] data) {
        checkState();
        this.data = data;
    }

    public String getApplicant() {
        return applicant;
    }

    public void setApplicant(String applicant) {
        checkState();
        this.applicant = applicant;
    }

    public String getContact() {
        return contact;
    }

    public void setContact(String contact) {
        checkState();
        this.contact = contact;
    }

    public int getTrialDuration() {
        return trialDuration;
    }

    public void setTrialDuration(int trialDuration) {
        checkState();
        this.trialDuration = trialDuration;
    }

    public Limit getLimit() {
        return limit;
    }

    public void setLimit(int limit) {
        checkState();
        if (limit > 0) {
            this.limit = new Limit(limit);
        }
    }
}
