/*
 * Decompiled with CFR 0.152.
 */
package tech.smartboot.license.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.concurrent.TimeUnit;
import javax.crypto.Cipher;
import tech.smartboot.license.client.LicenseEntity;
import tech.smartboot.license.client.LicenseException;
import tech.smartboot.license.client.Md5;
import tech.smartboot.license.client.RuntimeExpireStrategy;

public class License {
    public static final RuntimeExpireStrategy EXPIRE_STRATEGY_IGNORE = licenseEntity -> System.err.println("invalid license");
    public static final RuntimeExpireStrategy EXPIRE_STRATEGY_THROWS = licenseEntity -> {
        throw new LicenseException("invalid license");
    };
    private static final String KEY_ALGORITHM = "RSA";
    private final byte[] readBuffer = new byte[8];
    private final RuntimeExpireStrategy expireStrategy;
    private final RuntimeExpireStrategy trialExpireStrategy;
    private final long period;
    private LicenseEntity entity;
    private long timestamp;

    public License() {
        this(EXPIRE_STRATEGY_IGNORE, TimeUnit.HOURS.toMillis(1L));
    }

    public License(RuntimeExpireStrategy runtimeExpireStrategy, long l) {
        this(runtimeExpireStrategy, runtimeExpireStrategy, l);
    }

    public License(RuntimeExpireStrategy runtimeExpireStrategy, RuntimeExpireStrategy runtimeExpireStrategy2, long l) {
        if (l < TimeUnit.SECONDS.toMillis(1L)) {
            throw new IllegalArgumentException("period is too fast");
        }
        this.expireStrategy = runtimeExpireStrategy;
        this.trialExpireStrategy = runtimeExpireStrategy2;
        this.period = l;
    }

    private byte[] decryptByPublicKey(byte[] byArray, byte[] byArray2) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(byArray2);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            Cipher cipher = Cipher.getInstance(keyFactory.getAlgorithm());
            cipher.init(2, publicKey);
            return cipher.doFinal(byArray);
        }
        catch (Exception exception) {
            throw new LicenseException("decrypt exception", exception);
        }
    }

    private void monitorExpireThread() {
        Thread thread = new Thread(() -> {
            while (true) {
                long l = Math.min(this.entity.getExpireTime() - System.currentTimeMillis(), this.period);
                if (this.entity.getTrialDuration() > 0) {
                    l = Math.min(l, (long)this.entity.getTrialDuration() * 60000L);
                }
                if (l <= 0L) {
                    l = 10000L;
                }
                try {
                    Thread.sleep(l);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                if (this.entity.getExpireTime() < System.currentTimeMillis()) {
                    this.expireStrategy.expire(this.entity);
                    continue;
                }
                if (this.entity.getTrialDuration() <= 0 || System.currentTimeMillis() - this.timestamp <= (long)this.entity.getTrialDuration() * 60000L) continue;
                this.trialExpireStrategy.expire(this.entity);
            }
        }, "licenseMonitor");
        thread.setDaemon(true);
        thread.start();
    }

    public LicenseEntity loadLicense(byte[] byArray) throws IOException {
        LicenseEntity licenseEntity = this.replace(byArray);
        this.monitorExpireThread();
        return licenseEntity;
    }

    public LicenseEntity replace(byte[] byArray) throws IOException {
        Object object;
        byte[] byArray2;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        byte[] byArray3 = new byte[LicenseEntity.MAGIC_NUM.length];
        byteArrayInputStream.read(byArray3);
        this.checkBytes(byArray3, LicenseEntity.MAGIC_NUM);
        long l = this.readLong(byteArrayInputStream);
        if (l > System.currentTimeMillis()) {
            throw new LicenseException("invalid license");
        }
        long l2 = this.readLong(byteArrayInputStream);
        if (l2 < System.currentTimeMillis()) {
            throw new LicenseException("license expire");
        }
        byte[] byArray4 = new byte[this.readInt(byteArrayInputStream)];
        byteArrayInputStream.read(byArray4);
        byte[] byArray5 = new byte[this.readInt(byteArrayInputStream)];
        byteArrayInputStream.read(byArray5);
        byte[] byArray6 = new byte[this.readInt(byteArrayInputStream)];
        byteArrayInputStream.read(byArray6);
        byte[] byArray7 = new byte[this.readInt(byteArrayInputStream)];
        byteArrayInputStream.read(byArray7);
        int n = this.readInt(byteArrayInputStream);
        int n2 = this.readInt(byteArrayInputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n3 = 0;
        while ((n3 = byteArrayInputStream.read()) > 0) {
            byArray2 = new byte[n3];
            byteArrayInputStream.read(byArray2);
            object = this.decryptByPublicKey(byArray2, byArray5);
            byteArrayOutputStream.write((byte[])object);
            if (this.readLong(byteArrayInputStream) == l2 % (long)((byte[])object).length) continue;
            throw new LicenseException("invalid license");
        }
        byArray2 = byteArrayOutputStream.toByteArray();
        if (!Md5.md5(byArray2).equals(new String(byArray4))) {
            throw new LicenseException("invalid license");
        }
        object = new LicenseEntity(l2, byArray5);
        ((LicenseEntity)object).setApplicant(new String(byArray6));
        ((LicenseEntity)object).setContact(new String(byArray7));
        ((LicenseEntity)object).setTrialDuration(n);
        ((LicenseEntity)object).setLimit(n2);
        ((LicenseEntity)object).setData(byArray2);
        ((LicenseEntity)object).lock();
        this.entity = object;
        this.timestamp = System.currentTimeMillis();
        return object;
    }

    public LicenseEntity getEntity() {
        return this.entity;
    }

    private void checkBytes(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            throw new LicenseException("invalid license");
        }
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            throw new LicenseException("invalid license");
        }
    }

    private long readLong(InputStream inputStream) throws IOException {
        inputStream.read(this.readBuffer, 0, 8);
        return ((long)this.readBuffer[0] << 56) + ((long)(this.readBuffer[1] & 0xFF) << 48) + ((long)(this.readBuffer[2] & 0xFF) << 40) + ((long)(this.readBuffer[3] & 0xFF) << 32) + ((long)(this.readBuffer[4] & 0xFF) << 24) + (long)((this.readBuffer[5] & 0xFF) << 16) + (long)((this.readBuffer[6] & 0xFF) << 8) + (long)((this.readBuffer[7] & 0xFF) << 0);
    }

    private int readInt(InputStream inputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4 = inputStream.read();
        if ((n4 | (n3 = inputStream.read()) | (n2 = inputStream.read()) | (n = inputStream.read())) < 0) {
            throw new EOFException();
        }
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }
}

