package tech.smartboot.license.client;

import java.util.concurrent.Semaphore;

/**
 * @author 三刀
 * @version v1.0 5/8/25
 */
public class Limit {
    private final Semaphore semaphore;

    public Limit(Semaphore semaphore) {
        this.semaphore = semaphore;
    }

    public boolean tryAcquire() {
        return semaphore.tryAcquire();
    }

    public void release() {
        semaphore.release();
    }

    public int limit() {
        return semaphore.availablePermits();
    }
}
