/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit.runners;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import tech.sirwellington.alchemy.annotations.access.Internal;
import tech.sirwellington.alchemy.annotations.access.NonInstantiable;
import tech.sirwellington.alchemy.generator.AlchemyGenerator;
import tech.sirwellington.alchemy.generator.NetworkGenerators;
import tech.sirwellington.alchemy.test.Checks;

@Target(value={ElementType.FIELD})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface GenerateURL {
    public String protocol() default "http";

    @NonInstantiable
    @Internal
    public static class Values {
        private Values() throws IllegalAccessException {
            throw new IllegalAccessException("cannot instantiate");
        }

        static AlchemyGenerator<URL> createGeneratorFor(GenerateURL annotation) {
            Checks.Internal.checkNotNull(annotation, "annotation is missing");
            String protocol = annotation.protocol();
            Checks.Internal.checkNotNull(protocol, "protocol cannot be null");
            Checks.Internal.checkThat(!protocol.isEmpty(), "protocol is empty");
            return NetworkGenerators.urlsWithProtocol((String)protocol);
        }
    }
}

