/*
 * Decompiled with CFR 0.152.
 */
package tech.sirwellington.alchemy.test.junit;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import tech.sirwellington.alchemy.annotations.designs.FluidAPIDesign;
import tech.sirwellington.alchemy.test.Checks;
import tech.sirwellington.alchemy.test.junit.ExceptionNotThrownException;
import tech.sirwellington.alchemy.test.junit.ExceptionOperation;

@FluidAPIDesign
public final class ThrowableAssertion {
    private Throwable caught;
    private final ExceptionOperation operation;

    public static ThrowableAssertion assertThrows(ExceptionOperation operation) throws ExceptionNotThrownException {
        Checks.Internal.checkNotNull(operation, "missing operation");
        return new ThrowableAssertion(operation).execute();
    }

    private ThrowableAssertion(ExceptionOperation operation) {
        this.operation = operation;
    }

    private ThrowableAssertion execute() throws ExceptionNotThrownException {
        try {
            this.operation.call();
        }
        catch (Throwable ex) {
            this.caught = ex;
            return this;
        }
        throw new ExceptionNotThrownException("Expected an exception");
    }

    public ThrowableAssertion isInstanceOf(Class<? extends Throwable> exceptionClass) {
        Assert.assertThat((Object)this.caught, (Matcher)Matchers.isA(exceptionClass));
        return this;
    }

    public ThrowableAssertion hasMessage(String expectedMessage) {
        Assert.assertThat((Object)this.caught.getMessage(), (Matcher)Matchers.is((Object)expectedMessage));
        return this;
    }

    public ThrowableAssertion containsInMessage(String messageString) {
        Assert.assertThat((Object)this.caught.getMessage(), (Matcher)Matchers.containsString((String)messageString));
        return this;
    }

    public ThrowableAssertion hasNoCause() {
        Assert.assertThat((Object)this.caught.getCause(), (Matcher)Matchers.nullValue());
        return this;
    }

    public ThrowableAssertion hasCauseInstanceOf(Class<? extends Throwable> exceptionClass) {
        Assert.assertThat((Object)this.caught.getCause(), (Matcher)Matchers.notNullValue());
        Assert.assertThat((Object)this.caught.getCause(), (Matcher)Matchers.isA(exceptionClass));
        return this;
    }
}

